/*
 * Decompiled with CFR 0.152.
 */
package visualizer.converters;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import visualizer.projection.distance.DistanceMatrix;
import visualizer.util.OpenDialog;
import visualizer.util.SaveDialog;
import visualizer.util.Util;
import visualizer.util.filefilter.DMATFilter;
import visualizer.util.filefilter.NAMESFilter;

public class DistanceMatrixConverterView
extends JFrame {
    private JButton convert_jButton;
    private JButton distanceMatrixButton;
    private JTextField distanceMatrixTextField;
    private JButton namesButton;
    private JLabel namesLabel;
    private JTextField namesTextField;
    private JLabel newDmatLabel;
    private JTextField newMatrixFile_TextField;
    private JButton newMatrixFile_jButton;
    private JLabel oldDmatLabel;

    public DistanceMatrixConverterView() {
        this.initComponents();
    }

    private void initComponents() {
        this.distanceMatrixTextField = new JTextField();
        this.distanceMatrixButton = new JButton();
        this.oldDmatLabel = new JLabel();
        this.namesLabel = new JLabel();
        this.newDmatLabel = new JLabel();
        this.namesTextField = new JTextField();
        this.namesButton = new JButton();
        this.newMatrixFile_TextField = new JTextField();
        this.newMatrixFile_jButton = new JButton();
        this.convert_jButton = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("Distance Matrix File Converter");
        this.getContentPane().setLayout(new GridBagLayout());
        this.distanceMatrixTextField.setColumns(35);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.distanceMatrixTextField, gridBagConstraints);
        this.distanceMatrixButton.setText("Search...");
        this.distanceMatrixButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DistanceMatrixConverterView.this.distanceMatrixButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.distanceMatrixButton, gridBagConstraints);
        this.oldDmatLabel.setText("Old Matrix File");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.oldDmatLabel, gridBagConstraints);
        this.namesLabel.setText("Old Names File");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.namesLabel, gridBagConstraints);
        this.newDmatLabel.setText("New Matrix File");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.newDmatLabel, gridBagConstraints);
        this.namesTextField.setColumns(40);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.namesTextField, gridBagConstraints);
        this.namesButton.setText("Search...");
        this.namesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DistanceMatrixConverterView.this.namesButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.namesButton, gridBagConstraints);
        this.newMatrixFile_TextField.setColumns(35);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.newMatrixFile_TextField, gridBagConstraints);
        this.newMatrixFile_jButton.setText("Set Filename");
        this.newMatrixFile_jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DistanceMatrixConverterView.this.newMatrixFile_jButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.newMatrixFile_jButton, gridBagConstraints);
        this.convert_jButton.setText("Convert");
        this.convert_jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DistanceMatrixConverterView.this.convert_jButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.convert_jButton, gridBagConstraints);
        this.pack();
    }

    private void distanceMatrixButtonActionPerformed(ActionEvent evt) {
        int result = OpenDialog.showOpenDialog(new DMATFilter(), this);
        if (result == 0) {
            String filename = OpenDialog.getFilename();
            this.distanceMatrixTextField.setText(filename);
            String newFilename = filename.substring(0, filename.lastIndexOf("\\") + 1);
            newFilename = newFilename + "NEW_" + filename.substring(filename.lastIndexOf("\\") + 1, filename.length());
            this.newMatrixFile_TextField.setText(newFilename);
        }
    }

    private void namesButtonActionPerformed(ActionEvent evt) {
        int result = OpenDialog.showOpenDialog(new NAMESFilter(), this);
        if (result == 0) {
            String filename = OpenDialog.getFilename();
            this.namesTextField.setText(filename);
        }
    }

    private void newMatrixFile_jButtonActionPerformed(ActionEvent evt) {
        int result = SaveDialog.showSaveDialog(new DMATFilter(), this, "newMatrixFilename");
        if (result == 0) {
            String filename = SaveDialog.getFilename();
            this.newMatrixFile_TextField.setText(filename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convert_jButtonActionPerformed(ActionEvent evt) {
        BufferedReader in = null;
        BufferedWriter out = null;
        try {
            int i;
            int i2;
            Vector<String> names = Util.readOldNamesFile(this.namesTextField.getText());
            in = new BufferedReader(new FileReader(this.distanceMatrixTextField.getText()));
            String line = in.readLine();
            StringTokenizer tCdata = new StringTokenizer(line, " \t");
            Vector<Float> cdata = new Vector<Float>();
            while (tCdata.hasMoreTokens()) {
                String token = tCdata.nextToken();
                cdata.add(Float.valueOf(Float.parseFloat(token)));
            }
            int numberPoints = cdata.size();
            float[][] matrix = new float[numberPoints - 1][];
            int numberTerms = numberPoints - 1;
            for (int ins1 = 0; ins1 < numberPoints - 1; ++ins1) {
                matrix[ins1] = new float[numberTerms--];
            }
            int pointA = 0;
            int pointB = 0;
            int i3 = 0;
            while ((line = in.readLine()) != null) {
                int j = numberPoints - 1;
                StringTokenizer tDistance = new StringTokenizer(line, " \t");
                if (line.trim().length() > 0) {
                    while (tDistance.hasMoreTokens()) {
                        String token = tDistance.nextToken();
                        pointA = i3;
                        if (pointA < (pointB = j--)) {
                            matrix[pointA][Math.abs((int)(pointB - (numberPoints - 1)))] = Float.parseFloat(token);
                            continue;
                        }
                        matrix[pointB][Math.abs((int)(pointA - (numberPoints - 1)))] = Float.parseFloat(token);
                    }
                }
                ++i3;
            }
            DistanceMatrix dmat = new DistanceMatrix(numberPoints);
            out = new BufferedWriter(new FileWriter(this.newMatrixFile_TextField.getText()));
            out.write(Integer.toString(numberPoints));
            out.write("\r\n");
            if (names != null) {
                for (i2 = 0; i2 < names.size() - 1; ++i2) {
                    out.write(names.get(i2));
                    out.write(";");
                }
                out.write(names.get(names.size() - 1));
                out.write("\r\n");
            } else {
                for (i2 = 0; i2 < numberPoints - 1; ++i2) {
                    out.write(Integer.toString(i2) + ";");
                }
                out.write(Integer.toString(numberPoints - 1) + "\r\n");
            }
            if (cdata != null) {
                for (i2 = 0; i2 < cdata.size() - 1; ++i2) {
                    out.write(((Float)cdata.get(i2)).toString());
                    out.write(";");
                }
                out.write(((Float)cdata.get(cdata.size() - 1)).toString());
                out.write("\r\n");
            } else {
                for (i2 = 0; i2 < numberPoints - 1; ++i2) {
                    out.write("0;");
                }
                out.write("0\r\n");
            }
            float[][] newMatrix = new float[numberPoints - 1][];
            for (i = 0; i < numberPoints - 1; ++i) {
                newMatrix[i] = new float[i + 1];
            }
            for (int row = 0; row < matrix.length; ++row) {
                int sCol = numberPoints - 2;
                for (int col = 0; col < matrix[row].length; ++col) {
                    newMatrix[sCol][row] = matrix[row][col];
                    --sCol;
                }
            }
            for (i = 0; i < newMatrix.length; ++i) {
                for (int j = 0; j < newMatrix[i].length; ++j) {
                    out.write(Float.toString(newMatrix[i][j]));
                    if (j >= newMatrix[i].length - 1) continue;
                    out.write(";");
                }
                out.write("\r\n");
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new DistanceMatrixConverterView().setVisible(true);
            }
        });
    }
}

