/*
 * Decompiled with CFR 0.152.
 */
package visualizer.corpus.database;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import visualizer.corpus.database.ConnectionManager;

public class SqlManager {
    private final String sqlfilename = "./config/sql.properties";
    private Properties properties;
    private static SqlManager _instance;
    private boolean commit = false;

    private SqlManager() throws IOException {
        try {
            this.properties = new Properties();
            FileInputStream file = new FileInputStream(this.sqlfilename);
            this.properties.load(file);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(SqlManager.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOException(ex.getMessage());
        }
        catch (IOException ex) {
            Logger.getLogger(SqlManager.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOException(ex.getMessage());
        }
    }

    public static SqlManager getInstance() throws IOException {
        if (_instance == null) {
            _instance = new SqlManager();
        }
        return _instance;
    }

    public PreparedStatement getSqlStatement(String id) throws IOException {
        try {
            Connection conn = ConnectionManager.getInstance().getConnection();
            return conn.prepareStatement(this.properties.getProperty(id));
        }
        catch (SQLException ex) {
            Logger.getLogger(SqlManager.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOException(ex.getMessage());
        }
    }

    public void beginTransaction() throws IOException {
        try {
            Connection conn = ConnectionManager.getInstance().getConnection();
            this.commit = conn.getAutoCommit();
            conn.setAutoCommit(false);
        }
        catch (SQLException ex) {
            Logger.getLogger(SqlManager.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOException(ex.getMessage());
        }
    }

    public void endTransaction() throws IOException {
        try {
            Connection conn = ConnectionManager.getInstance().getConnection();
            conn.commit();
            conn.setAutoCommit(this.commit);
        }
        catch (SQLException ex) {
            Logger.getLogger(SqlManager.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOException(ex.getMessage());
        }
    }

    public void rollBackTransaction() throws IOException {
        try {
            Connection conn = ConnectionManager.getInstance().getConnection();
            conn.rollback();
        }
        catch (SQLException ex) {
            Logger.getLogger(SqlManager.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOException(ex.getMessage());
        }
    }
}

