/*
 * Decompiled with CFR 0.152.
 */
package visualizer.datamining.clustering;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import visualizer.datamining.clustering.BKmeans;
import visualizer.datamining.clustering.Clustering;
import visualizer.datamining.clustering.Kmedoids;
import visualizer.graph.Graph;
import visualizer.graph.Scalar;
import visualizer.graph.Vertex;
import visualizer.matrix.Matrix;
import visualizer.matrix.MatrixFactory;
import visualizer.projection.distance.Dissimilarity;
import visualizer.projection.distance.DissimilarityFactory;
import visualizer.projection.distance.DissimilarityType;
import visualizer.util.OpenDialog;
import visualizer.util.filefilter.DATAFilter;

public class MultidimensionalClusteringView
extends JDialog {
    private Scalar scalar;
    private Graph graph;
    private JRadioButton bkmeansRadioButton;
    private JPanel buttonPanel;
    private JPanel chooseDistanceTypePanel;
    private JButton closeButton;
    private ButtonGroup clusteringButtonGroup;
    private JPanel clusteringPanel;
    private JPanel clusteringTypePanel;
    private JPanel dataPanel;
    private JComboBox distanceComboBox;
    private JButton generateButton;
    private JRadioButton kmedoidsRadioButton;
    private JLabel nrclustersLabel;
    private JTextField nrclustersTextField;
    private JButton pointsButton;
    private JPanel pointsPanel;
    private JTextField pointsTextField;

    private MultidimensionalClusteringView(Frame parent) {
        super(parent);
        this.initComponents();
        for (DissimilarityType disstype : DissimilarityType.getTypes()) {
            if (disstype == DissimilarityType.KOLMOGOROV || disstype == DissimilarityType.NONE) continue;
            this.distanceComboBox.addItem(disstype);
        }
    }

    private void initComponents() {
        this.clusteringButtonGroup = new ButtonGroup();
        this.dataPanel = new JPanel();
        this.pointsPanel = new JPanel();
        this.pointsTextField = new JTextField();
        this.pointsButton = new JButton();
        this.chooseDistanceTypePanel = new JPanel();
        this.distanceComboBox = new JComboBox();
        this.clusteringPanel = new JPanel();
        this.clusteringTypePanel = new JPanel();
        this.kmedoidsRadioButton = new JRadioButton();
        this.bkmeansRadioButton = new JRadioButton();
        this.nrclustersLabel = new JLabel();
        this.nrclustersTextField = new JTextField();
        this.buttonPanel = new JPanel();
        this.generateButton = new JButton();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Clustering the Multidimensional Data");
        this.setModal(true);
        this.dataPanel.setBorder(BorderFactory.createTitledBorder("Data"));
        this.dataPanel.setLayout(new GridBagLayout());
        this.pointsPanel.setBorder(BorderFactory.createTitledBorder("Points File"));
        this.pointsPanel.setLayout(new GridBagLayout());
        this.pointsTextField.setColumns(35);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pointsPanel.add((Component)this.pointsTextField, gridBagConstraints);
        this.pointsButton.setText("Search...");
        this.pointsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultidimensionalClusteringView.this.pointsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pointsPanel.add((Component)this.pointsButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.dataPanel.add((Component)this.pointsPanel, gridBagConstraints);
        this.chooseDistanceTypePanel.setBorder(BorderFactory.createTitledBorder("Choose the Distance Type"));
        this.chooseDistanceTypePanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 3, 3);
        this.chooseDistanceTypePanel.add((Component)this.distanceComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.dataPanel.add((Component)this.chooseDistanceTypePanel, gridBagConstraints);
        this.clusteringPanel.setBorder(BorderFactory.createTitledBorder("Clustering Parameters"));
        this.clusteringPanel.setLayout(new GridBagLayout());
        this.clusteringTypePanel.setBorder(BorderFactory.createTitledBorder("Clustering Type"));
        this.clusteringTypePanel.setLayout(new GridBagLayout());
        this.clusteringButtonGroup.add(this.kmedoidsRadioButton);
        this.kmedoidsRadioButton.setText("K-medoids");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.clusteringTypePanel.add((Component)this.kmedoidsRadioButton, gridBagConstraints);
        this.clusteringButtonGroup.add(this.bkmeansRadioButton);
        this.bkmeansRadioButton.setSelected(true);
        this.bkmeansRadioButton.setText("Bisecting K-means");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.clusteringTypePanel.add((Component)this.bkmeansRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.clusteringPanel.add((Component)this.clusteringTypePanel, gridBagConstraints);
        this.nrclustersLabel.setText("Number Clusters");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 13, 3);
        this.clusteringPanel.add((Component)this.nrclustersLabel, gridBagConstraints);
        this.nrclustersTextField.setColumns(5);
        this.nrclustersTextField.setText("5");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 13, 3);
        this.clusteringPanel.add((Component)this.nrclustersTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.dataPanel.add((Component)this.clusteringPanel, gridBagConstraints);
        this.getContentPane().add((Component)this.dataPanel, "Center");
        this.generateButton.setText("Generate");
        this.generateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultidimensionalClusteringView.this.generateButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.generateButton);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultidimensionalClusteringView.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.getContentPane().add((Component)this.buttonPanel, "Last");
        this.pack();
    }

    private void pointsButtonActionPerformed(ActionEvent evt) {
        int result = OpenDialog.showOpenDialog(new DATAFilter(), this);
        if (result == 0) {
            String filename = OpenDialog.getFilename();
            this.pointsTextField.setText(filename);
        }
    }

    private void generateButtonActionPerformed(ActionEvent evt) {
        try {
            Matrix matrix = MatrixFactory.getInstance(this.pointsTextField.getText());
            DissimilarityType mtype = (DissimilarityType)this.distanceComboBox.getSelectedItem();
            Dissimilarity diss = DissimilarityFactory.getInstance(mtype);
            Clustering clustering = null;
            if (this.kmedoidsRadioButton.isSelected()) {
                this.scalar = this.graph.addScalar("bkmedoids-" + this.nrclustersTextField.getText());
                clustering = new Kmedoids(Integer.parseInt(this.nrclustersTextField.getText()));
            } else if (this.bkmeansRadioButton.isSelected()) {
                this.scalar = this.graph.addScalar("bkmeans-" + this.nrclustersTextField.getText());
                clustering = new BKmeans(Integer.parseInt(this.nrclustersTextField.getText()));
            }
            ArrayList<ArrayList<Integer>> clusters = clustering.execute(diss, matrix);
            HashMap<String, Integer> cindex = new HashMap<String, Integer>();
            for (int i = 0; i < clusters.size(); ++i) {
                for (int j = 0; j < clusters.get(i).size(); ++j) {
                    cindex.put(matrix.getRow(clusters.get(i).get(j)).getId(), i);
                }
            }
            for (Vertex v : this.graph.getVertex()) {
                if (cindex.containsKey(v.getUrl())) {
                    v.setScalar(this.scalar, ((Integer)cindex.get(v.getUrl())).intValue());
                    continue;
                }
                v.setScalar(this.scalar, 0.0f);
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Probably the points file is not the one used to create the projection!");
            }
            this.setVisible(false);
        }
        catch (IOException ex) {
            Logger.getLogger(MultidimensionalClusteringView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public static MultidimensionalClusteringView getInstance(JFrame parent) {
        return new MultidimensionalClusteringView(parent);
    }

    public Scalar display(Graph graph) {
        this.graph = graph;
        this.scalar = null;
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
        return this.scalar;
    }
}

