/*
 * Decompiled with CFR 0.152.
 */
package visualizer.datamining.dataanalysis;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import visualizer.datamining.dataanalysis.DistanceHistogramView;
import visualizer.datamining.dataanalysis.KruskalStress;
import visualizer.datamining.dataanalysis.SammonStress;
import visualizer.datamining.dataanalysis.Stress;
import visualizer.graph.Graph;
import visualizer.matrix.Matrix;
import visualizer.matrix.MatrixFactory;
import visualizer.projection.distance.Dissimilarity;
import visualizer.projection.distance.DissimilarityFactory;
import visualizer.projection.distance.DissimilarityType;
import visualizer.projection.distance.DistanceMatrix;
import visualizer.util.OpenDialog;
import visualizer.util.filefilter.DATAFilter;
import visualizer.util.filefilter.DMATFilter;

public class CalculateStressView
extends JDialog {
    private Graph graph;
    private JPanel buttonPanel;
    private JPanel chooseDistanceTypePanel2;
    private JButton closeButton;
    private JPanel dataPanel;
    private JComboBox distanceComboBox;
    private JButton distanceMatrixButton;
    private JRadioButton distanceMatrixRadioButton;
    private JTextField distanceMatrixTextField;
    private JButton generateButton;
    private JRadioButton kruskalRadioButton;
    private JButton pointsButton;
    private JRadioButton pointsRadioButton;
    private JTextField pointsTextField;
    private JRadioButton sammonRadioButton;
    private JPanel sourcePanel;
    private ButtonGroup stressButtonGroup;
    private JPanel stressPanel;

    private CalculateStressView(Frame parent) {
        super(parent);
        this.initComponents();
        for (DissimilarityType disstype : DissimilarityType.getTypes()) {
            if (disstype == DissimilarityType.KOLMOGOROV || disstype == DissimilarityType.NONE) continue;
            this.distanceComboBox.addItem(disstype);
        }
    }

    private void initComponents() {
        this.stressButtonGroup = new ButtonGroup();
        this.dataPanel = new JPanel();
        this.chooseDistanceTypePanel2 = new JPanel();
        this.distanceComboBox = new JComboBox();
        this.sourcePanel = new JPanel();
        this.pointsRadioButton = new JRadioButton();
        this.distanceMatrixRadioButton = new JRadioButton();
        this.distanceMatrixTextField = new JTextField();
        this.pointsTextField = new JTextField();
        this.pointsButton = new JButton();
        this.distanceMatrixButton = new JButton();
        this.stressPanel = new JPanel();
        this.kruskalRadioButton = new JRadioButton();
        this.sammonRadioButton = new JRadioButton();
        this.buttonPanel = new JPanel();
        this.generateButton = new JButton();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Calculate Stress");
        this.setModal(true);
        this.dataPanel.setBorder(BorderFactory.createTitledBorder("Data"));
        this.dataPanel.setLayout(new GridBagLayout());
        this.chooseDistanceTypePanel2.setBorder(BorderFactory.createTitledBorder("Choose the Distance Type"));
        this.chooseDistanceTypePanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 3, 3);
        this.chooseDistanceTypePanel2.add((Component)this.distanceComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.dataPanel.add((Component)this.chooseDistanceTypePanel2, gridBagConstraints);
        this.sourcePanel.setBorder(BorderFactory.createTitledBorder("Source File"));
        this.sourcePanel.setLayout(new GridBagLayout());
        this.pointsRadioButton.setSelected(true);
        this.pointsRadioButton.setText("Points File");
        this.pointsRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.pointsRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.pointsRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalculateStressView.this.pointsRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.pointsRadioButton, gridBagConstraints);
        this.distanceMatrixRadioButton.setText("Distance File");
        this.distanceMatrixRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.distanceMatrixRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.distanceMatrixRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalculateStressView.this.distanceMatrixRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.distanceMatrixRadioButton, gridBagConstraints);
        this.distanceMatrixTextField.setColumns(35);
        this.distanceMatrixTextField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.distanceMatrixTextField, gridBagConstraints);
        this.pointsTextField.setColumns(35);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.pointsTextField, gridBagConstraints);
        this.pointsButton.setText("Search...");
        this.pointsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalculateStressView.this.pointsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.pointsButton, gridBagConstraints);
        this.distanceMatrixButton.setText("Search...");
        this.distanceMatrixButton.setEnabled(false);
        this.distanceMatrixButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalculateStressView.this.distanceMatrixButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.distanceMatrixButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.dataPanel.add((Component)this.sourcePanel, gridBagConstraints);
        this.stressPanel.setBorder(BorderFactory.createTitledBorder("Stress Function"));
        this.stressPanel.setLayout(new GridBagLayout());
        this.stressButtonGroup.add(this.kruskalRadioButton);
        this.kruskalRadioButton.setSelected(true);
        this.kruskalRadioButton.setText("Kruskal's stress");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.stressPanel.add((Component)this.kruskalRadioButton, gridBagConstraints);
        this.stressButtonGroup.add(this.sammonRadioButton);
        this.sammonRadioButton.setText("Sammon's stress");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.stressPanel.add((Component)this.sammonRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.dataPanel.add((Component)this.stressPanel, gridBagConstraints);
        this.getContentPane().add((Component)this.dataPanel, "Center");
        this.generateButton.setText("Generate");
        this.generateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalculateStressView.this.generateButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.generateButton);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalculateStressView.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.getContentPane().add((Component)this.buttonPanel, "Last");
        this.pack();
    }

    private void pointsRadioButtonActionPerformed(ActionEvent evt) {
        this.distanceMatrixButton.setEnabled(false);
        this.distanceMatrixTextField.setEnabled(false);
        this.pointsButton.setEnabled(true);
        this.pointsTextField.setEnabled(true);
        this.distanceMatrixTextField.setText("");
        this.distanceComboBox.setEnabled(true);
    }

    private void distanceMatrixRadioButtonActionPerformed(ActionEvent evt) {
        this.distanceMatrixButton.setEnabled(true);
        this.distanceMatrixTextField.setEnabled(true);
        this.pointsButton.setEnabled(false);
        this.pointsTextField.setEnabled(false);
        this.pointsTextField.setText("");
        this.distanceComboBox.setEnabled(false);
    }

    private void pointsButtonActionPerformed(ActionEvent evt) {
        int result = OpenDialog.showOpenDialog(new DATAFilter(), this);
        if (result == 0) {
            String filename = OpenDialog.getFilename();
            this.pointsTextField.setText(filename);
        }
    }

    private void distanceMatrixButtonActionPerformed(ActionEvent evt) {
        int result = OpenDialog.showOpenDialog(new DMATFilter(), this);
        if (result == 0) {
            String filename = OpenDialog.getFilename();
            this.distanceMatrixTextField.setText(filename);
        }
    }

    private void generateButtonActionPerformed(ActionEvent evt) {
        if (this.pointsRadioButton.isSelected()) {
            if (this.pointsTextField.getText().trim().length() > 0) {
                try {
                    Matrix matrix = MatrixFactory.getInstance(this.pointsTextField.getText());
                    DissimilarityType mtype = (DissimilarityType)this.distanceComboBox.getSelectedItem();
                    Dissimilarity diss = DissimilarityFactory.getInstance(mtype);
                    Stress stress = null;
                    stress = this.kruskalRadioButton.isSelected() ? new KruskalStress() : new SammonStress();
                    float value = stress.calculate(matrix, diss, this.graph);
                    JOptionPane.showMessageDialog(this, "Stress= " + value, "Stress Value", 0);
                }
                catch (IOException ex) {
                    Logger.getLogger(DistanceHistogramView.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                JOptionPane.showMessageDialog(this, "A points file must be selected.", "Error", 0);
            }
        } else if (this.distanceMatrixRadioButton.isSelected()) {
            if (this.distanceMatrixTextField.getText().trim().length() > 0) {
                try {
                    DistanceMatrix dmat = new DistanceMatrix(this.distanceMatrixTextField.getText());
                    Stress stress = null;
                    stress = this.kruskalRadioButton.isSelected() ? new KruskalStress() : new SammonStress();
                    float value = stress.calculate(dmat, this.graph);
                    JOptionPane.showMessageDialog(this, "Stress= " + value, "Stress Value", 0);
                }
                catch (IOException ex) {
                    Logger.getLogger(DistanceHistogramView.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                JOptionPane.showMessageDialog(this, "A distance matrix file must be selected.", "Error", 0);
            }
        }
        this.setVisible(false);
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public static CalculateStressView getInstance(JFrame parent) {
        return new CalculateStressView(parent);
    }

    public void display(Graph graph) {
        this.graph = graph;
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }
}

