/*
 * Decompiled with CFR 0.152.
 */
package visualizer.datamining.dataanalysis;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.sf.epsgraphics.ColorMode;
import net.sf.epsgraphics.EpsGraphics;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import visualizer.datamining.dataanalysis.NeighborhoodHit;
import visualizer.util.SaveDialog;
import visualizer.util.Util;
import visualizer.util.filefilter.EPSFilter;

public class CreateLineGraph
extends JDialog {
    private JFreeChart freechart;
    private JPanel panel;
    private JPanel buttonPanel;
    private JButton closeButton;
    private JButton saveImageButton;

    public CreateLineGraph(JDialog parent) {
        super(parent);
        this.initComponents();
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.saveImageButton = new JButton();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.saveImageButton.setText("Save Image");
        this.saveImageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateLineGraph.this.saveImageButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.saveImageButton);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateLineGraph.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.getContentPane().add((Component)this.buttonPanel, "Last");
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveImageButtonActionPerformed(ActionEvent evt) {
        int result = SaveDialog.showSaveDialog(new EPSFilter(), this, "image.eps");
        if (result == 0) {
            String filename = SaveDialog.getFilename();
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(filename);
                EpsGraphics g = new EpsGraphics(filename, (OutputStream)out, 0, 0, this.panel.getWidth() + 1, this.panel.getHeight() + 1, ColorMode.COLOR_RGB);
                this.freechart.draw((Graphics2D)g, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, this.panel.getWidth() + 1, this.panel.getHeight() + 1));
                g.flush();
                g.close();
            }
            catch (IOException ex) {
                Logger.getLogger(NeighborhoodHit.class.getName()).log(Level.SEVERE, null, ex);
                JOptionPane.showMessageDialog(this, ex.getMessage(), "Problems saving the file", 0);
            }
            finally {
                if (out != null) {
                    try {
                        out.flush();
                        out.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(NeighborhoodHit.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public static CreateLineGraph getInstance(JDialog parent) {
        return new CreateLineGraph(parent);
    }

    public void display(ArrayList<Serie> series) throws IOException {
        this.freechart = this.createChart(this.createAllSeries(series));
        this.panel = new ChartPanel(this.freechart);
        this.getContentPane().add((Component)this.panel, "Center");
        this.setPreferredSize(new Dimension(650, 400));
        this.setSize(new Dimension(650, 400));
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    private JFreeChart createChart(XYDataset xydataset) {
        JFreeChart chart = ChartFactory.createXYLineChart((String)"Erro da Proje\u00e7\u00e3o", (String)"N\u00famero de Itera\u00e7\u00f5es", (String)"Precis\u00e3o", (XYDataset)xydataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        XYPlot xyplot = (XYPlot)chart.getPlot();
        NumberAxis numberaxis = (NumberAxis)xyplot.getRangeAxis();
        numberaxis.setAutoRangeIncludesZero(false);
        xyplot.setDomainGridlinePaint((Paint)Color.BLACK);
        xyplot.setRangeGridlinePaint((Paint)Color.BLACK);
        xyplot.setOutlinePaint((Paint)Color.BLACK);
        xyplot.setOutlineStroke((Stroke)new BasicStroke(1.0f));
        xyplot.setBackgroundPaint((Paint)Color.white);
        xyplot.setDomainCrosshairVisible(true);
        xyplot.setRangeCrosshairVisible(true);
        xyplot.setDrawingSupplier((DrawingSupplier)new DefaultDrawingSupplier(new Paint[]{Color.RED, Color.BLUE, Color.GREEN, Color.MAGENTA, Color.CYAN, Color.ORANGE, Color.BLACK, Color.DARK_GRAY, Color.GRAY, Color.LIGHT_GRAY, Color.YELLOW}, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE));
        XYLineAndShapeRenderer xylineandshaperenderer = (XYLineAndShapeRenderer)xyplot.getRenderer();
        xylineandshaperenderer.setBaseShapesVisible(true);
        xylineandshaperenderer.setBaseShapesFilled(true);
        xylineandshaperenderer.setDrawOutlines(true);
        return chart;
    }

    private XYDataset createAllSeries(ArrayList<Serie> series) throws IOException {
        XYSeriesCollection xyseriescollection = new XYSeriesCollection();
        for (int i = 0; i < series.size(); ++i) {
            double[] values = this.readValues(series.get((int)i).filename);
            XYSeries xyseries = this.createSerie(series.get((int)i).name, values);
            xyseriescollection.addSeries(xyseries);
        }
        return xyseriescollection;
    }

    private XYSeries createSerie(String name, double[] values) {
        XYSeries xyseries = new XYSeries((Comparable)((Object)name));
        for (int i = 0; i < values.length; ++i) {
            xyseries.add((double)(i + 1), values[i]);
        }
        return xyseries;
    }

    private double[] readValues(String filename) throws IOException {
        double[] values = null;
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(filename));
            ArrayList<Float> values_aux = new ArrayList<Float>();
            String line = null;
            while ((line = in.readLine()) != null) {
                if (line.trim().length() <= 0) continue;
                values_aux.add(Float.valueOf(Float.parseFloat(line)));
            }
            values = new double[values_aux.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = ((Float)values_aux.get(i)).floatValue();
            }
        }
        catch (FileNotFoundException ex) {
            throw new IOException(ex.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(Util.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return values;
    }

    public static void main(String[] args) {
        try {
            Serie serie1 = new Serie("Fastamp", "D:\\My Documents\\FERNANDO\\Tese\\datasets\\fastmap.txt");
            Serie serie2 = new Serie("Aleat\u00f3rio", "D:\\My Documents\\FERNANDO\\Tese\\datasets\\aleatorio.txt");
            ArrayList<Serie> series = new ArrayList<Serie>();
            series.add(serie1);
            series.add(serie2);
            CreateLineGraph.getInstance(null).display(series);
        }
        catch (IOException ex) {
            Logger.getLogger(CreateLineGraph.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static class Serie {
        public String name;
        public String filename;

        public Serie(String name, String filename) {
            this.name = name;
            this.filename = filename;
        }
    }
}

