/*
 * Decompiled with CFR 0.152.
 */
package visualizer.datamining.dataanalysis;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.sf.epsgraphics.ColorMode;
import net.sf.epsgraphics.EpsGraphics;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import visualizer.datamining.dataanalysis.MessageDialog;
import visualizer.graph.Graph;
import visualizer.graph.Scalar;
import visualizer.graph.XMLGraphParser;
import visualizer.matrix.Matrix;
import visualizer.projection.distance.DistanceMatrix;
import visualizer.projection.distance.Euclidean;
import visualizer.util.KNN;
import visualizer.util.Pair;
import visualizer.util.SaveDialog;
import visualizer.util.Util;
import visualizer.util.filefilter.EPSFilter;

public class NeighborhoodHit
extends JDialog {
    private JFreeChart freechart;
    private JPanel panel;
    private JPanel buttonPanel;
    private JButton closeButton;
    private JButton saveImageButton;

    private NeighborhoodHit(JDialog parent) {
        super(parent);
        this.initComponents();
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.saveImageButton = new JButton();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Neighborhood Hit");
        this.setModal(true);
        this.saveImageButton.setText("Save Image");
        this.saveImageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NeighborhoodHit.this.saveImageButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.saveImageButton);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NeighborhoodHit.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.getContentPane().add((Component)this.buttonPanel, "Last");
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveImageButtonActionPerformed(ActionEvent evt) {
        int result = SaveDialog.showSaveDialog(new EPSFilter(), this, "image.eps");
        if (result == 0) {
            String filename = SaveDialog.getFilename();
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(filename);
                EpsGraphics g = new EpsGraphics(filename, (OutputStream)out, 0, 0, this.panel.getWidth() + 1, this.panel.getHeight() + 1, ColorMode.COLOR_RGB);
                this.freechart.draw((Graphics2D)g, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, this.panel.getWidth() + 1, this.panel.getHeight() + 1));
                g.flush();
                g.close();
            }
            catch (IOException ex) {
                Logger.getLogger(NeighborhoodHit.class.getName()).log(Level.SEVERE, null, ex);
                JOptionPane.showMessageDialog(this, ex.getMessage(), "Problems saving the file", 0);
            }
            finally {
                if (out != null) {
                    try {
                        out.flush();
                        out.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(NeighborhoodHit.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public static NeighborhoodHit getInstance(JDialog parent) {
        return new NeighborhoodHit(parent);
    }

    public void display(final ArrayList<Serie> series, final int maxneigh) {
        final MessageDialog md = MessageDialog.show(this, "Calculating neighborhood hit...");
        Thread t = new Thread(){

            @Override
            public void run() {
                NeighborhoodHit.this.freechart = NeighborhoodHit.this.createChart(NeighborhoodHit.this.createAllSeries(series, maxneigh));
                NeighborhoodHit.this.panel = (JPanel)new ChartPanel(NeighborhoodHit.this.freechart);
                NeighborhoodHit.this.getContentPane().add((Component)NeighborhoodHit.this.panel, "Center");
                NeighborhoodHit.this.setPreferredSize(new Dimension(650, 400));
                NeighborhoodHit.this.setSize(new Dimension(650, 400));
                NeighborhoodHit.this.setLocationRelativeTo(NeighborhoodHit.this.getParent());
                md.close();
                NeighborhoodHit.this.setVisible(true);
            }
        };
        t.start();
    }

    private JFreeChart createChart(XYDataset xydataset) {
        JFreeChart chart = ChartFactory.createXYLineChart((String)"Neighborhood Hit", (String)"Number Neighbors", (String)"Precision", (XYDataset)xydataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        XYPlot xyplot = (XYPlot)chart.getPlot();
        NumberAxis numberaxis = (NumberAxis)xyplot.getRangeAxis();
        numberaxis.setAutoRangeIncludesZero(false);
        xyplot.setDomainGridlinePaint((Paint)Color.BLACK);
        xyplot.setRangeGridlinePaint((Paint)Color.BLACK);
        xyplot.setOutlinePaint((Paint)Color.BLACK);
        xyplot.setOutlineStroke((Stroke)new BasicStroke(1.0f));
        xyplot.setBackgroundPaint((Paint)Color.white);
        xyplot.setDomainCrosshairVisible(true);
        xyplot.setRangeCrosshairVisible(true);
        xyplot.setDrawingSupplier((DrawingSupplier)new DefaultDrawingSupplier(new Paint[]{Color.RED, Color.BLUE, Color.GREEN, Color.MAGENTA, Color.CYAN, Color.ORANGE, Color.BLACK, Color.DARK_GRAY, Color.GRAY, Color.LIGHT_GRAY, Color.YELLOW}, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE));
        XYLineAndShapeRenderer xylineandshaperenderer = (XYLineAndShapeRenderer)xyplot.getRenderer();
        xylineandshaperenderer.setBaseShapesVisible(true);
        xylineandshaperenderer.setBaseShapesFilled(true);
        xylineandshaperenderer.setDrawOutlines(true);
        return chart;
    }

    private XYDataset createAllSeries(ArrayList<Serie> series, int maxneigh) {
        XYSeriesCollection xyseriescollection = new XYSeriesCollection();
        for (int i = 0; i < series.size(); ++i) {
            double[] values = this.neighborhoodHit(series.get((int)i).filename, maxneigh);
            XYSeries xyseries = this.createSerie(series.get((int)i).name, values);
            xyseriescollection.addSeries(xyseries);
        }
        return xyseriescollection;
    }

    private XYSeries createSerie(String name, double[] values) {
        XYSeries xyseries = new XYSeries((Comparable)((Object)name));
        for (int i = 0; i < values.length; ++i) {
            xyseries.add((double)(i + 1), values[i]);
        }
        return xyseries;
    }

    private double[] neighborhoodHit(String filename, int maxneigh) {
        double[] values = new double[maxneigh];
        try {
            XMLGraphParser parser = new XMLGraphParser();
            Graph graph = parser.parse(filename);
            Scalar scdata = graph.getScalarByName("cdata");
            Matrix points = Util.exportProjection(graph, scdata);
            DistanceMatrix dmat = new DistanceMatrix(points, new Euclidean());
            for (int n = 0; n < maxneigh; ++n) {
                KNN knn = new KNN(n + 1);
                Pair[][] neighbors = knn.execute(dmat);
                float percentage = 0.0f;
                for (int i = 0; i < points.getRowCount(); ++i) {
                    float c = points.getRow(i).getKlass();
                    float total = 0.0f;
                    for (int j = 0; j < n + 1; ++j) {
                        if (c != points.getRow(neighbors[i][j].index).getKlass()) continue;
                        total += 1.0f;
                    }
                    percentage += total / (float)(n + 1);
                }
                values[n] = percentage / (float)points.getRowCount();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(NeighborhoodHit.class.getName()).log(Level.SEVERE, null, ex);
        }
        return values;
    }

    public static class Serie {
        public String name;
        public String filename;

        public Serie(String name, String filename) {
            this.name = name;
            this.filename = filename;
        }
    }
}

