/*
 * Decompiled with CFR 0.152.
 */
package visualizer.datamining.dataanalysis;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import visualizer.datamining.dataanalysis.NeighborhoodHit;
import visualizer.util.OpenDialog;
import visualizer.util.filefilter.XMLFilter;

public class NeighborhoodHitView
extends JDialog {
    private DefaultTableModel projTableModel;
    private JButton addButton;
    private JPanel buttonPanel;
    private JButton closeButton;
    private JButton generateButton;
    private JLabel nrNeighborsLabel;
    private JPanel nrNeighborsPanel;
    private JTextField nrNeighborsTextField;
    private JPanel projButtonPanel;
    private JPanel projPanel;
    private JScrollPane projScrollPane;
    private JTable projTable;
    private JButton removeButton;

    private NeighborhoodHitView(Frame parent) {
        super(parent);
        this.initComponents();
        this.initModels();
        this.projTable.setModel(this.projTableModel);
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.generateButton = new JButton();
        this.closeButton = new JButton();
        this.projPanel = new JPanel();
        this.projScrollPane = new JScrollPane();
        this.projTable = new JTable();
        this.projButtonPanel = new JPanel();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.nrNeighborsPanel = new JPanel();
        this.nrNeighborsLabel = new JLabel();
        this.nrNeighborsTextField = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setTitle("Neighborhood Hit");
        this.setModal(true);
        this.generateButton.setText("Generate");
        this.generateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NeighborhoodHitView.this.generateButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.generateButton);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NeighborhoodHitView.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.getContentPane().add((Component)this.buttonPanel, "Last");
        this.projPanel.setBorder(BorderFactory.createTitledBorder("Projections"));
        this.projPanel.setLayout(new BorderLayout(5, 5));
        this.projScrollPane.setViewportView(this.projTable);
        this.projPanel.add((Component)this.projScrollPane, "Center");
        this.projButtonPanel.setLayout(new GridBagLayout());
        this.addButton.setText("Add");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NeighborhoodHitView.this.addButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.projButtonPanel.add((Component)this.addButton, gridBagConstraints);
        this.removeButton.setText("Remove");
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NeighborhoodHitView.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.projButtonPanel.add((Component)this.removeButton, gridBagConstraints);
        this.projPanel.add((Component)this.projButtonPanel, "After");
        this.nrNeighborsPanel.setLayout(new FlowLayout(0));
        this.nrNeighborsLabel.setText("Number of neighbors");
        this.nrNeighborsPanel.add(this.nrNeighborsLabel);
        this.nrNeighborsTextField.setColumns(10);
        this.nrNeighborsTextField.setText("30");
        this.nrNeighborsPanel.add(this.nrNeighborsTextField);
        this.projPanel.add((Component)this.nrNeighborsPanel, "Last");
        this.getContentPane().add((Component)this.projPanel, "Center");
        this.pack();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        int result = OpenDialog.showOpenDialog(new XMLFilter(), this);
        if (result == 0) {
            String filename = OpenDialog.getFilename();
            String description = filename.substring(filename.lastIndexOf("\\") + 1, filename.lastIndexOf("."));
            this.projTableModel.addRow(new String[]{description, filename});
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int index = this.projTable.getSelectedRow();
        if (index > -1) {
            this.projTableModel.removeRow(index);
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void generateButtonActionPerformed(ActionEvent evt) {
        ArrayList<NeighborhoodHit.Serie> series = new ArrayList<NeighborhoodHit.Serie>();
        for (int i = 0; i < this.projTable.getRowCount(); ++i) {
            String filename = (String)this.projTable.getValueAt(i, 1);
            if (filename.trim().length() <= 0) continue;
            String description = (String)this.projTable.getValueAt(i, 0);
            NeighborhoodHit.Serie serie = new NeighborhoodHit.Serie(description, filename);
            series.add(serie);
        }
        NeighborhoodHit.getInstance(this).display(series, Integer.parseInt(this.nrNeighborsTextField.getText()));
    }

    public static NeighborhoodHitView getInstance(JFrame parent) {
        return new NeighborhoodHitView(parent);
    }

    public void display() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    private void initModels() {
        Object[] titles = new String[]{"Description", "File name"};
        this.projTableModel = new DefaultTableModel((Object[][])null, titles);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                NeighborhoodHitView dialog = new NeighborhoodHitView((Frame)new JFrame());
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

