/*
 * Decompiled with CFR 0.152.
 */
package visualizer.dimensionreduction;

import java.io.IOException;
import visualizer.dimensionreduction.DimensionalityReduction;
import visualizer.dimensionreduction.DimensionalityReductionType;
import visualizer.dimensionreduction.Fastmap;
import visualizer.dimensionreduction.KMeansReduction;
import visualizer.dimensionreduction.PCA;

public class DimensionalityReductionFactory {
    public static DimensionalityReduction getInstance(DimensionalityReductionType type, int target) throws IOException {
        DimensionalityReduction dr = null;
        if (type == DimensionalityReductionType.KMEANS) {
            dr = new KMeansReduction(target);
        } else if (type == DimensionalityReductionType.PCA) {
            dr = new PCA(target);
        } else if (type == DimensionalityReductionType.FASTMAP) {
            dr = new Fastmap(target);
        }
        return dr;
    }
}

