/*
 * Decompiled with CFR 0.152.
 */
package visualizer.dimensionreduction;

import java.io.IOException;
import java.util.Arrays;
import visualizer.dimensionreduction.DimensionalityReduction;
import visualizer.matrix.Matrix;
import visualizer.matrix.Vector;
import visualizer.projection.distance.Dissimilarity;

public class Fastmap
extends DimensionalityReduction {
    public Fastmap(int targetDimension) {
        super(targetDimension);
    }

    @Override
    protected float[][] execute(Matrix matrix, Dissimilarity diss) throws IOException {
        float[][] projection = new float[matrix.getRowCount()][];
        for (int i = 0; i < matrix.getRowCount(); ++i) {
            projection[i] = new float[this.targetDimension];
            Arrays.fill(projection[i], 0.0f);
        }
        for (int curDim = 0; curDim < this.targetDimension; ++curDim) {
            int i;
            int[] pivots = this.chooseDistantObjects(matrix, projection, curDim, diss);
            float pDistance = this.distance(matrix.getRow(pivots[0]), matrix.getRow(pivots[1]), projection[pivots[0]], projection[pivots[1]], curDim, diss);
            if (pDistance == 0.0f) {
                for (i = 0; i < matrix.getRowCount(); ++i) {
                    projection[i][curDim] = 0.0f;
                }
                continue;
            }
            for (i = 0; i < matrix.getRowCount(); ++i) {
                float lvxi;
                projection[i][curDim] = lvxi = (float)((Math.pow(this.distance(matrix.getRow(pivots[0]), matrix.getRow(i), projection[pivots[0]], projection[i], curDim, diss), 2.0) + Math.pow(this.distance(matrix.getRow(pivots[0]), matrix.getRow(pivots[1]), projection[pivots[0]], projection[pivots[1]], curDim, diss), 2.0) - Math.pow(this.distance(matrix.getRow(pivots[1]), matrix.getRow(i), projection[pivots[1]], projection[i], curDim, diss), 2.0)) / (double)(2.0f * this.distance(matrix.getRow(pivots[0]), matrix.getRow(pivots[1]), projection[pivots[0]], projection[pivots[1]], curDim, diss)));
            }
        }
        return projection;
    }

    private float distance(Vector vectA, Vector vectB, float[] projA, float[] projB, int dimension, Dissimilarity diss) throws IOException {
        float dist = diss.calculate(vectA, vectB);
        for (int i = 0; i < dimension; ++i) {
            dist = (float)Math.sqrt(Math.abs(Math.pow(dist, 2.0) - Math.pow(projA[i] - projB[i], 2.0)));
        }
        return dist;
    }

    private int[] chooseDistantObjects(Matrix matrix, float[][] projection, int dimension, Dissimilarity diss) throws IOException {
        int[] choosen = new int[2];
        int x = (int)(Math.random() * (double)(matrix.getRowCount() - 1));
        float maxdist = Float.MIN_VALUE;
        for (int i = 0; i < matrix.getRowCount(); ++i) {
            float aux = this.distance(matrix.getRow(x), matrix.getRow(i), projection[x], projection[i], dimension, diss);
            if (!(aux > maxdist)) continue;
            maxdist = aux;
            x = i;
        }
        int y = 0;
        maxdist = Float.MIN_VALUE;
        for (int i = 0; i < matrix.getRowCount(); ++i) {
            float aux = this.distance(matrix.getRow(x), matrix.getRow(i), projection[x], projection[i], dimension, diss);
            if (!(aux > maxdist)) continue;
            maxdist = aux;
            y = i;
        }
        choosen[0] = x;
        choosen[1] = y;
        return choosen;
    }
}

