/*
 * Decompiled with CFR 0.152.
 */
package visualizer.featureextraction;

import visualizer.featureextraction.GenericMask;

public class CircularMask
extends GenericMask {
    private int ray;

    CircularMask(int row, int col, int ray) {
        super(row, col);
        this.ray = ray;
    }

    public void setRay(int ray) {
        this.ray = ray;
    }

    public int getRay() {
        return this.ray;
    }

    @Override
    public void createMask() {
        int x = 0;
        int y = this.ray;
        int d = 1 / this.ray;
        int xO = this.Col / 2;
        int yO = this.Row / 2;
        this.circlePoints(xO, yO, x, y);
        while ((double)x <= (double)this.ray / 1.4142) {
            if (d < 0) {
                d += 2 * x + 3;
            } else {
                d += 2 * (x - y) + 5;
                --y;
            }
            this.circlePoints(xO, yO, ++x, y);
        }
        this.fill(xO, yO + this.ray);
    }

    private void circlePoints(int xO, int yO, int x, int y) {
        this.mask[y + yO][x + xO] = 1.0;
        this.mask[y + yO][-x + xO] = 1.0;
        this.mask[-y + yO][x + xO] = 1.0;
        this.mask[-y + yO][-x + xO] = 1.0;
        this.mask[x + yO][y + xO] = 1.0;
        this.mask[x + yO][-y + xO] = 1.0;
        this.mask[-x + yO][y + xO] = 1.0;
        this.mask[-x + yO][-y + xO] = 1.0;
    }

    private void fill(int x, int y) {
        int yc = y - 1;
        while (this.mask[yc][x] == 0.0) {
            this.mask[yc][x] = 1.0;
            int xd = x + 1;
            while (this.mask[yc][xd] == 0.0) {
                this.mask[yc][xd] = 1.0;
                ++xd;
            }
            int xe = x - 1;
            while (this.mask[yc][xe] == 0.0) {
                this.mask[yc][xe] = 1.0;
                --xe;
            }
            --yc;
        }
    }
}

