/*
 * Decompiled with CFR 0.152.
 */
package visualizer.featureextraction;

import visualizer.featureextraction.Complex;

public class DFT1D {
    private int N = 0;
    private double[] data = null;

    public DFT1D(double[] d) {
        int len;
        if (d != null && (len = d.length) > 0) {
            this.N = len;
            this.data = d;
        }
    }

    public Complex dftPoint(int m) {
        double twoPi = Math.PI * 2;
        Complex cx = new Complex(0.0, 0.0);
        if (m >= 0 && m < this.N) {
            double R = 0.0;
            double I = 0.0;
            if (m == 0) {
                for (int n = 0; n < this.N; ++n) {
                    double p = this.data[n];
                    R += p;
                }
            } else {
                for (int n = 0; n < this.N; ++n) {
                    Double p = this.data[n];
                    double x = p;
                    double scale = Math.PI * 2 * (double)n * (double)m / (double)this.N;
                    R += x * Math.cos(scale);
                    I -= x * Math.sin(scale);
                }
            }
            cx.setReal(R);
            cx.setImag(I);
        }
        return cx;
    }
}

