/*
 * Decompiled with CFR 0.152.
 */
package visualizer.featureextraction;

import ij.IJ;
import ij.ImagePlus;
import ij.process.ImageConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import visualizer.featureextraction.Feature;
import visualizer.featureextraction.PExImageFeatures;
import visualizer.projection.ProjectionData;

public class ExtractionManager {
    private float[][] matrixPoints;
    private ArrayList<String> nameImages;
    private float[] nameClasses;
    private float[] cdata;

    public ExtractionManager(ProjectionData pdata, String pathname) {
        ImagePlus imp = null;
        File[] filesTrainer = new File(pathname).listFiles();
        ImagePlus[] vectorImagesOpened = new ImagePlus[filesTrainer.length];
        int totalFeatures = 28;
        this.matrixPoints = new float[filesTrainer.length][totalFeatures];
        File directory = new File(pathname);
        try {
            int i;
            this.nameImages = this.getNameImages(filesTrainer);
            this.createCdata(filesTrainer);
            for (i = 0; i < filesTrainer.length; ++i) {
                imp = this.openImage(filesTrainer[i]);
                vectorImagesOpened[i] = imp = this.imagePreProcessing(imp);
            }
            boolean indiceFeature = false;
            PExImageFeatures extractor = new PExImageFeatures();
            double[] result = null;
            System.out.println("\nExtracting PEx-Image Features");
            for (i = 0; i < filesTrainer.length; ++i) {
                System.out.println("# Image " + (i + 1) + ":");
                result = ((Feature)extractor).extract(vectorImagesOpened[i]);
                for (int j = 0; j < result.length; ++j) {
                    this.matrixPoints[i][j] = (float)result[j];
                }
            }
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    public float[][] getMatrixPoints() {
        return this.matrixPoints;
    }

    public ArrayList<String> getNameImages() {
        return this.nameImages;
    }

    public float[] getClasses() {
        return this.nameClasses;
    }

    public float[] getClassData() {
        return this.cdata;
    }

    private ArrayList<String> getNameImages(File[] filesTrainer) {
        ArrayList<String> nameImages = new ArrayList<String>();
        for (int i = 0; i < filesTrainer.length; ++i) {
            nameImages.add(filesTrainer[i].getName());
        }
        return nameImages;
    }

    private void createCdata(File[] filesTrainer) {
        if (filesTrainer.length > 0) {
            int i;
            ArrayList<String> initials_aux = new ArrayList<String>();
            for (int i2 = 0; i2 < filesTrainer.length; ++i2) {
                String ini;
                String filename = filesTrainer[i2].getName();
                int begin = filename.lastIndexOf("_");
                if (begin > -1) {
                    ini = filename = filename.substring(0, begin);
                } else {
                    ini = filename;
                    if (filename.length() > 2) {
                        ini = filename.substring(0, 2);
                    }
                }
                if (initials_aux.contains(ini)) continue;
                initials_aux.add(ini);
            }
            Object[] initials = new String[initials_aux.size()];
            for (i = 0; i < initials_aux.size(); ++i) {
                initials[i] = (String)initials_aux.get(i);
            }
            Arrays.sort(initials);
            if (initials.length > 1) {
                this.cdata = new float[filesTrainer.length];
                for (i = 0; i < filesTrainer.length; ++i) {
                    this.cdata[i] = -1.0f;
                    for (int j = 0; j < initials.length; ++j) {
                        String filename = filesTrainer[i].getName();
                        int begin = filename.lastIndexOf("_");
                        if (begin > -1) {
                            filename = filename.substring(0, begin);
                        }
                        if (!filename.startsWith((String)initials[j])) continue;
                        this.cdata[i] = j;
                    }
                }
            } else {
                this.cdata = new float[filesTrainer.length];
                Arrays.fill(this.cdata, 0.0f);
            }
        }
    }

    private float[] getClasses(File[] filesTrainer) {
        float[] nameClasses = new float[filesTrainer.length];
        for (int i = 0; i < filesTrainer.length; ++i) {
            String[] temp = filesTrainer[i].getName().split("_");
            nameClasses[i] = Float.parseFloat(temp[0].replaceFirst("classe", ""));
        }
        return nameClasses;
    }

    public ImagePlus imagePreProcessing(ImagePlus imp) {
        ImageConverter ic = new ImageConverter(imp);
        ic.convertToGray8();
        return imp;
    }

    public ImagePlus openImage(File filesTrainer) {
        ImagePlus imp = null;
        imp = IJ.openImage(filesTrainer.getPath());
        if (imp == null) {
            System.out.println("A imagem n\u00c3\u00a3o pode ser aberta.");
        }
        return imp;
    }
}

