/*
 * Decompiled with CFR 0.152.
 */
package visualizer.featureextraction;

public abstract class GenericMask {
    protected int Row;
    protected int Col;
    protected double[][] mask;

    GenericMask(int row, int col) {
        this.Row = row;
        this.Col = col;
        this.mask = new double[this.Row][this.Col];
    }

    public void setRow(int row) {
        this.Row = row;
    }

    public int getRow() {
        return this.Row;
    }

    public void setCol(int col) {
        this.Col = col;
    }

    public int getCol() {
        return this.Col;
    }

    public void allocateMask() {
        this.mask = new double[this.Row][this.Col];
    }

    public double[][] getMask() {
        return this.mask;
    }

    public void setMask(double[][] mask) {
        this.mask = mask;
    }

    public int getNumberOfNonZeros() {
        int sum = 0;
        for (int y = 0; y < this.Row; ++y) {
            for (int x = 0; x < this.Col; ++x) {
                if (this.mask[y][x] != 1.0) continue;
                ++sum;
            }
        }
        return sum;
    }

    abstract void createMask();
}

