/*
 * Decompiled with CFR 0.152.
 */
package visualizer.forcelayout;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import visualizer.forcelayout.Force;
import visualizer.forcelayout.RungeKuttaIntegrator;
import visualizer.forcelayout.Spring;
import visualizer.graph.Vertex;

public class ForceSimulator {
    private Set items;
    private Set springs;
    private Force[] iforces;
    private Force[] sforces;
    private int iflen = 0;
    private int sflen = 0;
    private RungeKuttaIntegrator integrator = new RungeKuttaIntegrator();
    private float speedLimit = 1.0f;

    public ForceSimulator() {
        this.iforces = new Force[5];
        this.sforces = new Force[5];
        this.items = new HashSet();
        this.springs = new HashSet();
    }

    public float getSpeedLimit() {
        return this.speedLimit;
    }

    public void setSpeedLimit(float limit) {
        this.speedLimit = limit;
    }

    public void clear() {
        this.items.clear();
        Iterator siter = this.springs.iterator();
        Spring.SpringFactory f = Spring.getFactory();
        while (siter.hasNext()) {
            f.reclaim((Spring)siter.next());
        }
        this.springs.clear();
    }

    public void addForce(Force f) {
        Force[] newf;
        if (f.isItemForce()) {
            if (this.iforces.length == this.iflen) {
                newf = new Force[this.iflen + 10];
                System.arraycopy(this.iforces, 0, newf, 0, this.iforces.length);
                this.iforces = newf;
            }
            this.iforces[this.iflen++] = f;
        }
        if (f.isSpringForce()) {
            if (this.sforces.length == this.sflen) {
                newf = new Force[this.sflen + 10];
                System.arraycopy(this.sforces, 0, newf, 0, this.sforces.length);
                this.sforces = newf;
            }
            this.sforces[this.sflen++] = f;
        }
    }

    public Force[] getForces() {
        Force[] rv = new Force[this.iflen + this.sflen];
        System.arraycopy(this.iforces, 0, rv, 0, this.iflen);
        System.arraycopy(this.sforces, 0, rv, this.iflen, this.sflen);
        return rv;
    }

    public void addItem(Vertex item) {
        this.items.add(item);
    }

    public boolean removeItem(Vertex item) {
        return this.items.remove(item);
    }

    public Iterator getItems() {
        return this.items.iterator();
    }

    public Spring addSpring(Vertex item1, Vertex item2) {
        return this.addSpring(item1, item2, -1.0f, -1.0f);
    }

    public Spring addSpring(Vertex item1, Vertex item2, float length) {
        return this.addSpring(item1, item2, -1.0f, length);
    }

    public Spring addSpring(Vertex item1, Vertex item2, float coeff, float length) {
        if (item1 == null || item2 == null) {
            throw new IllegalArgumentException("ForceItems must be non-null");
        }
        Spring s = Spring.getFactory().getSpring(item1, item2, coeff, length);
        this.springs.add(s);
        return s;
    }

    public boolean removeSpring(Spring s) {
        return this.springs.remove(s);
    }

    public Iterator getSprings() {
        return this.springs.iterator();
    }

    public void runSimulator(long timestep) {
        this.accumulate();
        this.integrator.integrate(this, timestep);
    }

    public void accumulate() {
        int i;
        for (i = 0; i < this.iflen; ++i) {
            this.iforces[i].init(this);
        }
        for (i = 0; i < this.sflen; ++i) {
            this.sforces[i].init(this);
        }
        for (Vertex vertex : this.items) {
            vertex.fdata.force[0] = 0.0f;
            vertex.fdata.force[1] = 0.0f;
            for (int i2 = 0; i2 < this.iflen; ++i2) {
                this.iforces[i2].getForce(vertex);
            }
        }
        for (Spring s : this.springs) {
            for (int i3 = 0; i3 < this.sflen; ++i3) {
                this.sforces[i3].getForce(s);
            }
        }
    }
}

