/*
 * Decompiled with CFR 0.152.
 */
package visualizer.forcelayout;

import java.util.Iterator;
import visualizer.forcelayout.ForceSimulator;
import visualizer.graph.Vertex;

public class RungeKuttaIntegrator {
    public void integrate(ForceSimulator sim, long timestep) {
        float v;
        float vy;
        float vx;
        float[][] l;
        float[][] k;
        float coeff;
        Vertex item;
        float speedLimit = sim.getSpeedLimit();
        Iterator iter = sim.getItems();
        while (iter.hasNext()) {
            item = (Vertex)iter.next();
            coeff = (float)timestep / item.fdata.mass;
            k = item.fdata.k;
            l = item.fdata.l;
            item.fdata.plocation[0] = item.fdata.location[0];
            item.fdata.plocation[1] = item.fdata.location[1];
            k[0][0] = (float)timestep * item.fdata.velocity[0];
            k[0][1] = (float)timestep * item.fdata.velocity[1];
            l[0][0] = coeff * item.fdata.force[0];
            l[0][1] = coeff * item.fdata.force[1];
            item.fdata.location[0] = item.fdata.location[0] + 0.5f * k[0][0];
            item.fdata.location[1] = item.fdata.location[1] + 0.5f * k[0][1];
        }
        sim.accumulate();
        iter = sim.getItems();
        while (iter.hasNext()) {
            item = (Vertex)iter.next();
            coeff = (float)timestep / item.fdata.mass;
            k = item.fdata.k;
            l = item.fdata.l;
            vx = item.fdata.velocity[0] + 0.5f * l[0][0];
            vy = item.fdata.velocity[1] + 0.5f * l[0][1];
            v = (float)Math.sqrt(vx * vx + vy * vy);
            if (v > speedLimit) {
                vx = speedLimit * vx / v;
                vy = speedLimit * vy / v;
            }
            k[1][0] = (float)timestep * vx;
            k[1][1] = (float)timestep * vy;
            l[1][0] = coeff * item.fdata.force[0];
            l[1][1] = coeff * item.fdata.force[1];
            item.fdata.location[0] = item.fdata.plocation[0] + 0.5f * k[1][0];
            item.fdata.location[1] = item.fdata.plocation[1] + 0.5f * k[1][1];
        }
        sim.accumulate();
        iter = sim.getItems();
        while (iter.hasNext()) {
            item = (Vertex)iter.next();
            coeff = (float)timestep / item.fdata.mass;
            k = item.fdata.k;
            l = item.fdata.l;
            vx = item.fdata.velocity[0] + 0.5f * l[1][0];
            vy = item.fdata.velocity[1] + 0.5f * l[1][1];
            v = (float)Math.sqrt(vx * vx + vy * vy);
            if (v > speedLimit) {
                vx = speedLimit * vx / v;
                vy = speedLimit * vy / v;
            }
            k[2][0] = (float)timestep * vx;
            k[2][1] = (float)timestep * vy;
            l[2][0] = coeff * item.fdata.force[0];
            l[2][1] = coeff * item.fdata.force[1];
            item.fdata.location[0] = item.fdata.plocation[0] + 0.5f * k[2][0];
            item.fdata.location[1] = item.fdata.plocation[1] + 0.5f * k[2][1];
        }
        sim.accumulate();
        iter = sim.getItems();
        while (iter.hasNext()) {
            item = (Vertex)iter.next();
            coeff = (float)timestep / item.fdata.mass;
            k = item.fdata.k;
            l = item.fdata.l;
            float[] p = item.fdata.plocation;
            vx = item.fdata.velocity[0] + l[2][0];
            vy = item.fdata.velocity[1] + l[2][1];
            v = (float)Math.sqrt(vx * vx + vy * vy);
            if (v > speedLimit) {
                vx = speedLimit * vx / v;
                vy = speedLimit * vy / v;
            }
            k[3][0] = (float)timestep * vx;
            k[3][1] = (float)timestep * vy;
            l[3][0] = coeff * item.fdata.force[0];
            l[3][1] = coeff * item.fdata.force[1];
            item.fdata.location[0] = p[0] + (k[0][0] + k[3][0]) / 6.0f + (k[1][0] + k[2][0]) / 3.0f;
            item.fdata.location[1] = p[1] + (k[0][1] + k[3][1]) / 6.0f + (k[1][1] + k[2][1]) / 3.0f;
            vx = (l[0][0] + l[3][0]) / 6.0f + (l[1][0] + l[2][0]) / 3.0f;
            vy = (l[0][1] + l[3][1]) / 6.0f + (l[1][1] + l[2][1]) / 3.0f;
            v = (float)Math.sqrt(vx * vx + vy * vy);
            if (v > speedLimit) {
                vx = speedLimit * vx / v;
                vy = speedLimit * vy / v;
            }
            item.fdata.velocity[0] = item.fdata.velocity[0] + vx;
            item.fdata.velocity[1] = item.fdata.velocity[1] + vy;
        }
    }
}

