/*
 * Decompiled with CFR 0.152.
 */
package visualizer.forcelayout;

import java.util.ArrayList;
import visualizer.graph.Vertex;

public class Spring {
    private static SpringFactory s_factory = new SpringFactory();
    public Vertex item1;
    public Vertex item2;
    public float length;
    public float coeff;

    public static SpringFactory getFactory() {
        return s_factory;
    }

    public Spring(Vertex fi1, Vertex fi2, float k, float len) {
        this.item1 = fi1;
        this.item2 = fi2;
        this.coeff = k;
        this.length = len;
    }

    public static final class SpringFactory {
        private int maxSprings = 10000;
        private ArrayList springs = new ArrayList();

        public Spring getSpring(Vertex f1, Vertex f2, float k, float length) {
            if (this.springs.size() > 0) {
                Spring s = (Spring)this.springs.remove(this.springs.size() - 1);
                s.item1 = f1;
                s.item2 = f2;
                s.coeff = k;
                s.length = length;
                return s;
            }
            return new Spring(f1, f2, k, length);
        }

        public void reclaim(Spring s) {
            s.item1 = null;
            s.item2 = null;
            if (this.springs.size() < this.maxSprings) {
                this.springs.add(s);
            }
        }
    }
}

