/*
 * Decompiled with CFR 0.152.
 */
package visualizer.google;

import com.google.soap.search.GoogleSearchFault;
import com.google.soap.search.GoogleSearchResult;
import com.google.soap.search.GoogleSearchResultElement;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import visualizer.google.GoogleSearch;

public class GoogleGetter {
    public static final int SUCCESS = 0;
    public static final int INVALID_KEY = 1;
    private GoogleSearch gSearch;

    public GoogleGetter(GoogleSearch gSearch) {
        this.gSearch = gSearch;
    }

    public void search(String query, String key, int numberPages, String corpusFile) {
        ArrayList<GoogleSearchResultElement> results = new ArrayList<GoogleSearchResultElement>();
        com.google.soap.search.GoogleSearch s = new com.google.soap.search.GoogleSearch();
        s.setKey(key);
        s.setQueryString(query);
        s.setMaxResults(10);
        s.setSafeSearch(false);
        int i = 0;
        int count = 0;
        int countAnt = -1;
        while (count < numberPages * 10) {
            s.setStartResult(10 * i);
            try {
                GoogleSearchResult r = s.doSearch();
                for (GoogleSearchResultElement elem : r.getResultElements()) {
                    if (this.addElem(elem, results)) {
                        ++count;
                    }
                    this.gSearch.setNumberFetchedDocuments(count);
                }
                if (countAnt == count) break;
                countAnt = count;
            }
            catch (GoogleSearchFault ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            }
            ++i;
        }
        this.results2Zip(results, corpusFile);
    }

    private List<File> results2Files(List<GoogleSearchResultElement> Rs, String corpusFile) throws FileNotFoundException {
        File dir = new File(corpusFile.replaceFirst(".zip", "Full"));
        ArrayList<File> files = new ArrayList<File>();
        if (dir.exists()) {
            if (dir.isDirectory()) {
                String[] children = dir.list();
                for (int i = 0; i < children.length; ++i) {
                    boolean success = new File(dir, children[i]).delete();
                }
            }
        } else {
            dir.mkdir();
        }
        System.out.println("Retrieving results...");
        int count = -1;
        for (GoogleSearchResultElement r : Rs) {
            PrintWriter out;
            File outFile;
            try {
                String line;
                System.out.println("Retrieving " + ++count + " of " + Rs.size() + ":\t" + r.getURL());
                InputStreamReader input = new InputStreamReader(this.loadURL(r.getURL()));
                BufferedReader in = new BufferedReader(input);
                String output = this.url2FileName(r.getURL());
                outFile = new File(dir, output);
                out = new PrintWriter(outFile);
                while ((line = in.readLine()) != null) {
                    out.println(line);
                }
                out.close();
                files.add(outFile);
            }
            catch (Exception e) {
                System.err.println("Could not retreive " + r.getURL());
                System.err.println(e.getMessage());
                String text = this.snipet2Text(r, count);
                String output = this.url2FileName(r.getURL());
                outFile = new File(dir, output);
                out = new PrintWriter(outFile);
                out.println(text);
                out.close();
                System.err.println("Used snipet ");
            }
        }
        return files;
    }

    private InputStream loadURL(String url) throws Exception {
        URL sourceUrl = null;
        boolean validUrlFormat = true;
        try {
            sourceUrl = new URL(url);
        }
        catch (MalformedURLException e) {
            validUrlFormat = false;
        }
        if (validUrlFormat) {
            URLConnection connection = sourceUrl.openConnection();
            connection.setReadTimeout(10000);
            return connection.getInputStream();
        }
        return null;
    }

    private boolean addElem(GoogleSearchResultElement elem, List<GoogleSearchResultElement> results) {
        boolean found = false;
        for (GoogleSearchResultElement e : results) {
            if (!e.getURL().equals(elem.getURL())) continue;
            found = true;
            break;
        }
        if (!found) {
            results.add(elem);
        }
        return !found;
    }

    private String url2FileName(String url) {
        String output = url;
        output = output.replaceAll("://", "_");
        output = output.replace('/', '_');
        output = output.replace(':', '_');
        output = output.replace('?', '_');
        output = output.replace(';', '_');
        output = output.replace('.', '_');
        output = output.replace('=', '_');
        output = output.replace('~', '_');
        output = "GOOGLE_" + output + ".html";
        return output;
    }

    private String snipet2Text(GoogleSearchResultElement re, long i) {
        DecimalFormat myFormatter2 = new DecimalFormat("0000");
        String text = myFormatter2.format(i) + " - " + re.getTitle() + "\n" + "<br><p>" + re.getSnippet() + "</p><br>\n" + "<p>" + re.getHostName() + "</p>\n" + "<br><p><a href=\"" + re.getURL() + "\">" + re.getURL() + "</a></p><br>";
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void results2Zip(List<GoogleSearchResultElement> rs, String filename) {
        ZipOutputStream zos = null;
        try {
            File zipFile = new File(filename);
            zos = new ZipOutputStream(new FileOutputStream(zipFile));
            DecimalFormat myFormatter2 = new DecimalFormat("0000");
            for (int i = 0; i < rs.size(); ++i) {
                String output = this.url2FileName(rs.get(i).getURL());
                ZipEntry anEntry = new ZipEntry(output);
                zos.putNextEntry(anEntry);
                String text = this.snipet2Text(rs.get(i), i);
                zos.write(text.getBytes());
                zos.closeEntry();
            }
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }
}

