/*
 * Decompiled with CFR 0.152.
 */
package visualizer.google;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GoogleSearchManager {
    private String googlePropertiesFile = "google/googlesearch.properties";
    private Properties properties = null;
    private static GoogleSearchManager _instance = null;

    private GoogleSearchManager() {
        try {
            this.properties = new Properties();
            FileInputStream in = new FileInputStream(this.googlePropertiesFile);
            this.properties.load(in);
            in.close();
            String[] queries = this.getQueries();
            for (int i = 0; i < queries.length; ++i) {
                if (new File(this.getCorpus(queries[i])).exists()) continue;
                this.removeQuery(queries[i]);
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static GoogleSearchManager getInstance() {
        if (_instance == null) {
            _instance = new GoogleSearchManager();
        }
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newQuery(String query, String corpus) {
        this.properties.setProperty(query, corpus);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.googlePropertiesFile);
            this.properties.store(out, "Store the google queries");
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQuery(String query) {
        this.properties.remove(query);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.googlePropertiesFile);
            this.properties.store(out, "Store the google queries");
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public String getCorpus(String query) {
        return this.properties.getProperty(query);
    }

    public String[] getQueries() {
        Enumeration<Object> storedQueries = this.properties.keys();
        ArrayList<String> queries = new ArrayList<String>();
        while (storedQueries.hasMoreElements()) {
            queries.add((String)storedQueries.nextElement());
        }
        String[] queriesRet = new String[queries.size()];
        for (int i = 0; i < queries.size(); ++i) {
            queriesRet[i] = (String)queries.get(i);
        }
        return queriesRet;
    }
}

