/*
 * Decompiled with CFR 0.152.
 */
package visualizer.google;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import visualizer.google.GoogleSearch;
import visualizer.google.GoogleSearchManager;
import visualizer.google.GoogleSearchTableModel;
import visualizer.wizard.DataSourceChoice;

public class GoogleView
extends JDialog {
    private static final long serialVersionUID = 1L;
    private DefaultListModel listModel = new DefaultListModel();
    private GoogleSearchTableModel tableModel = new GoogleSearchTableModel();
    private ArrayList<GoogleSearch> searches = new ArrayList();
    private DataSourceChoice dataSourceChoice;
    private static GoogleView instance;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JButton closeButton;
    private JPanel dataPanel;
    private JButton executeButton;
    private JPanel newSearchPanel;
    private JLabel numberDocsLabel;
    private JSlider numberDocsSlider;
    private JTextField numberDocsTextField;
    private JPanel queriesButtonPanel;
    private JPanel queriesExecutionPanel;
    private JScrollPane queriesScrollPane;
    private JTable queriesTable;
    private JLabel queryLabel;
    private JTextField queryTextField;
    private JButton removeCorporaButton;
    private JList removeCorporaList;
    private JPanel removeCorpusButtonPanel;
    private JPanel removeCorpusPanel;
    private JScrollPane removeCorpusScrollPane;

    private GoogleView(JFrame parent) {
        super(parent);
        this.initComponents();
    }

    private GoogleView(JDialog parent) {
        super(parent);
        this.initComponents();
    }

    private void initComponents() {
        this.dataPanel = new JPanel();
        this.queriesExecutionPanel = new JPanel();
        this.queriesScrollPane = new JScrollPane();
        this.queriesTable = new JTable(this.tableModel);
        this.queriesButtonPanel = new JPanel();
        this.cancelButton = new JButton();
        this.newSearchPanel = new JPanel();
        this.queryLabel = new JLabel();
        this.queryTextField = new JTextField();
        this.numberDocsSlider = new JSlider();
        this.numberDocsLabel = new JLabel();
        this.executeButton = new JButton();
        this.numberDocsTextField = new JTextField();
        this.removeCorpusPanel = new JPanel();
        this.removeCorpusScrollPane = new JScrollPane();
        this.removeCorporaList = new JList(this.listModel);
        this.removeCorpusButtonPanel = new JPanel();
        this.removeCorporaButton = new JButton();
        this.buttonPanel = new JPanel();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Google");
        this.setModal(true);
        this.setResizable(false);
        this.dataPanel.setBorder(BorderFactory.createTitledBorder("Google Parameters"));
        this.dataPanel.setMaximumSize(new Dimension(100, 100));
        this.dataPanel.setMinimumSize(new Dimension(100, 100));
        this.dataPanel.setLayout(new BorderLayout());
        this.queriesExecutionPanel.setBorder(BorderFactory.createTitledBorder("Queries Under Execution"));
        this.queriesExecutionPanel.setLayout(new BorderLayout());
        this.queriesScrollPane.setMaximumSize(new Dimension(100, 100));
        this.queriesScrollPane.setPreferredSize(new Dimension(100, 100));
        this.queriesTable.setModel(this.tableModel);
        this.queriesScrollPane.setViewportView(this.queriesTable);
        this.queriesExecutionPanel.add((Component)this.queriesScrollPane, "Center");
        this.queriesButtonPanel.setLayout(new FlowLayout(2));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GoogleView.this.cancelButtonActionPerformed(evt);
            }
        });
        this.queriesButtonPanel.add(this.cancelButton);
        this.queriesExecutionPanel.add((Component)this.queriesButtonPanel, "South");
        this.dataPanel.add((Component)this.queriesExecutionPanel, "Center");
        this.newSearchPanel.setBorder(BorderFactory.createTitledBorder("New Search"));
        this.newSearchPanel.setLayout(new GridBagLayout());
        this.queryLabel.setText("Query");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.newSearchPanel.add((Component)this.queryLabel, gridBagConstraints);
        this.queryTextField.setColumns(40);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.newSearchPanel.add((Component)this.queryTextField, gridBagConstraints);
        this.numberDocsSlider.setMajorTickSpacing(100);
        this.numberDocsSlider.setMaximum(1000);
        this.numberDocsSlider.setMinimum(10);
        this.numberDocsSlider.setMinorTickSpacing(10);
        this.numberDocsSlider.setPaintLabels(true);
        this.numberDocsSlider.setPaintTicks(true);
        this.numberDocsSlider.setSnapToTicks(true);
        this.numberDocsSlider.setValue(100);
        this.numberDocsSlider.setPreferredSize(new Dimension(350, 50));
        this.numberDocsSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                GoogleView.this.numberDocsSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.newSearchPanel.add((Component)this.numberDocsSlider, gridBagConstraints);
        this.numberDocsLabel.setText("Number Documents");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.newSearchPanel.add((Component)this.numberDocsLabel, gridBagConstraints);
        this.executeButton.setText("Execute");
        this.executeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GoogleView.this.executeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(14, 0, 5, 0);
        this.newSearchPanel.add((Component)this.executeButton, gridBagConstraints);
        this.numberDocsTextField.setColumns(5);
        this.numberDocsTextField.setEditable(false);
        this.numberDocsTextField.setText("100");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.newSearchPanel.add((Component)this.numberDocsTextField, gridBagConstraints);
        this.dataPanel.add((Component)this.newSearchPanel, "North");
        this.removeCorpusPanel.setBorder(BorderFactory.createTitledBorder("Delete Corpus"));
        this.removeCorpusPanel.setLayout(new BorderLayout());
        this.removeCorporaList.setVisibleRowCount(5);
        this.removeCorpusScrollPane.setViewportView(this.removeCorporaList);
        this.removeCorpusPanel.add((Component)this.removeCorpusScrollPane, "Center");
        this.removeCorpusButtonPanel.setLayout(new FlowLayout(2));
        this.removeCorporaButton.setText("Remove");
        this.removeCorporaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GoogleView.this.removeCorporaButtonActionPerformed(evt);
            }
        });
        this.removeCorpusButtonPanel.add(this.removeCorporaButton);
        this.removeCorpusPanel.add((Component)this.removeCorpusButtonPanel, "South");
        this.dataPanel.add((Component)this.removeCorpusPanel, "South");
        this.getContentPane().add((Component)this.dataPanel, "Center");
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GoogleView.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
    }

    private void removeCorporaButtonActionPerformed(ActionEvent evt) {
        Object[] queries = this.removeCorporaList.getSelectedValues();
        GoogleSearchManager manager = GoogleSearchManager.getInstance();
        if (queries.length > 0) {
            for (int i = 0; i < queries.length; ++i) {
                String file = manager.getCorpus((String)queries[i]);
                manager.removeQuery((String)queries[i]);
                this.listModel.removeElement(queries[i]);
                File f = new File(file);
                if (f.exists()) {
                    f.delete();
                }
                System.out.println(file);
            }
        } else {
            JOptionPane.showMessageDialog(this, "It is necessary to select a query to remove!", "Error", 0);
        }
        if (this.dataSourceChoice != null) {
            this.dataSourceChoice.reset();
        }
    }

    private void numberDocsSliderStateChanged(ChangeEvent evt) {
        this.numberDocsTextField.setText(Integer.toString(this.numberDocsSlider.getValue()));
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        if (this.queriesTable.getSelectedRow() >= 0) {
            GoogleSearch gsearch = this.searches.get(this.queriesTable.getSelectedRow());
            gsearch.stopSearch();
        } else {
            JOptionPane.showMessageDialog(this, "It is necessary to select a query to cancel!", "Error", 0);
        }
    }

    private void executeButtonActionPerformed(ActionEvent evt) {
        if (this.queryTextField.getText().trim().length() > 0) {
            GoogleSearch gsearch = new GoogleSearch("8wE642dQFHKK9JfZqVTeQdBnbKJQrSpG", this);
            gsearch.search(this.queryTextField.getText(), this.numberDocsSlider.getValue());
            this.searches.add(gsearch);
            this.tableModel.addRow(gsearch);
            this.queryTextField.setText("");
        } else {
            JOptionPane.showMessageDialog(this, "It is necessary to provide a query!", "Error", 0);
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public static GoogleView getInstance(Container parent) {
        if (instance == null || instance.getParent() != parent) {
            instance = parent instanceof JFrame ? new GoogleView((JFrame)parent) : new GoogleView((JDialog)parent);
        }
        return instance;
    }

    public void display(DataSourceChoice dataSourceChoice) {
        this.dataSourceChoice = dataSourceChoice;
        this.queryTextField.setText("");
        this.numberDocsSlider.setValue(0);
        GoogleSearchManager manager = GoogleSearchManager.getInstance();
        Object[] queries = manager.getQueries();
        Arrays.sort(queries);
        this.listModel.clear();
        for (Object query : queries) {
            this.listModel.addElement(query);
        }
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    public void updateTable() {
        this.tableModel.update();
    }

    public synchronized void removeQuery(GoogleSearch gsearch) {
        int index = this.searches.indexOf(gsearch);
        if (index > -1) {
            this.searches.remove(index);
            this.tableModel.removeRow(index);
        }
    }

    public synchronized void queryFinished(GoogleSearch gsearch) {
        if (!this.isVisible()) {
            String msg = "Query towards " + gsearch.getQuery().substring(0, gsearch.getQuery().lastIndexOf("[")) + " is finished!";
            JOptionPane.showMessageDialog(this, msg, "Query finished", 2);
        }
        this.removeQuery(gsearch);
        this.listModel.addElement(gsearch.getQuery());
        if (this.dataSourceChoice != null) {
            this.dataSourceChoice.reset();
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new GoogleView(new JFrame()).setVisible(true);
            }
        });
    }
}

