/*
 * Decompiled with CFR 0.152.
 */
package visualizer.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import visualizer.graph.Edge;
import visualizer.graph.Vertex;
import visualizer.util.Pair;

public class Connectivity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name = "none";
    private ArrayList<Edge> edges = new ArrayList();

    public Connectivity(String name) {
        this.setName(name);
    }

    public ArrayList<Edge> getEdges() {
        return this.edges;
    }

    public void setEdges(ArrayList<Edge> edges) {
        if (edges != null) {
            this.edges = edges;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Connectivity create(ArrayList<Vertex> vertex, Pair[][] neighborhood) {
        if (neighborhood != null) {
            HashMap<Long, Vertex> index = new HashMap<Long, Vertex>();
            for (Vertex v : vertex) {
                index.put(v.getId(), v);
            }
            for (int i = 0; i < neighborhood.length; ++i) {
                for (int j = 0; j < neighborhood[i].length; ++j) {
                    this.edges.add(new Edge(neighborhood[i][j].value, (Vertex)index.get(i), (Vertex)index.get(neighborhood[i][j].index)));
                }
            }
            this.edges = Connectivity.compress(this.edges);
            this.setEdges(this.edges);
        }
        return this;
    }

    public static ArrayList<Edge> compress(ArrayList<Edge> edges) {
        if (edges.size() > 0) {
            Collections.sort(edges);
            ArrayList<Edge> edges_aux = edges;
            edges = new ArrayList();
            int n = 0;
            edges.add(edges_aux.get(0));
            for (int i = 1; i < edges_aux.size(); ++i) {
                if (edges_aux.get(n).equals(edges_aux.get(i))) continue;
                edges.add(edges_aux.get(i));
                n = i;
            }
        }
        return edges;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Connectivity) {
            return this.name.equals(((Connectivity)obj).name);
        }
        return false;
    }

    public int hashCode() {
        int hash = 3 + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return this.name;
    }
}

