/*
 * Decompiled with CFR 0.152.
 */
package visualizer.graph;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import visualizer.corpus.zip.ZipCorpus;
import visualizer.dimensionreduction.DimensionalityReductionType;
import visualizer.graph.Connectivity;
import visualizer.graph.Edge;
import visualizer.graph.Graph;
import visualizer.graph.Scalar;
import visualizer.graph.Vertex;
import visualizer.projection.ProjectionType;
import visualizer.projection.ProjectorType;
import visualizer.projection.SourceType;
import visualizer.projection.distance.DissimilarityType;
import visualizer.projection.distance.kolmogorov.CompressorType;

public class XMLGraphParser
extends DefaultHandler {
    private ArrayList<Vertex> vertex;
    private Vertex tempVertex;
    private Graph graph;
    private Connectivity con;
    private ArrayList<Edge> edges;
    private HashMap<Long, Vertex> vertexIndex;
    private static final String GRAPH = "graph";
    private static final String DESCRIPTION = "description";
    private static final String VERTEX = "vertex";
    private static final String VALID = "valid";
    private static final String NAME = "name";
    private static final String LABEL = "label";
    private static final String ID = "id";
    private static final String X_COORDINATE = "x-coordinate";
    private static final String Y_COORDINATE = "y-coordinate";
    private static final String URL = "url";
    private static final String VALUE = "value";
    private static final String SCALAR = "scalar";
    private static final String EDGES = "edges";
    private static final String EDGE = "edge";
    private static final String SOURCE = "source";
    private static final String TARGET = "target";
    private static final String LENGTH = "length";
    private static final String SOURCE_TYPE = "source-type";
    private static final String PROJECTION_TECHNIQUE = "projection-technique";
    private static final String DISTANCE_TYPE = "distance-type";
    private static final String SOURCE_FILE = "source-file";
    private static final String NUMBER_ITERATIONS = "number-iterations";
    private static final String FRACTION_DELTA = "fraction-delta";
    private static final String PROJECTION_TYPE = "projection-type";
    private static final String LUHN_LOWER_CUT = "luhn-lower-cut";
    private static final String LUHN_UPPER_CUT = "luhn-upper-cut";
    private static final String NUMBER_GRAMS = "number-grams";
    private static final String COMPRESSOR_TYPE = "compressor-type";
    private static final String CLUSTER_FACTOR = "cluster-factor";
    private static final String NUMBER_NEIGHBORS = "number-neighbors";
    private static final String NUMBER_CONTROL_POINTS = "number-control-points";
    private static final String NUMBER_OBJECTS = "number-objects";
    private static final String NUMBER_DIMENSIONS = "number-dimensions";
    private static final String DIMEN_REDUCTION = "dimensionality-reduction";
    private static final String RESULTING_DIMEN = "resulting-dimensions";

    public Graph parse(String filename) throws IOException {
        this.graph = new Graph();
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            InputSource in = new InputSource(new InputStreamReader((InputStream)new FileInputStream(filename), "ISO-8859-1"));
            SAXParser sp = spf.newSAXParser();
            sp.parse(in, (DefaultHandler)this);
        }
        catch (SAXException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
        return this.graph;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        if (qName.equalsIgnoreCase(VERTEX)) {
            this.vertex.add(this.tempVertex);
        } else if (qName.equalsIgnoreCase(EDGES)) {
            this.edges = Connectivity.compress(this.edges);
            this.con.setEdges(this.edges);
            this.graph.addConnectivity(this.con);
        } else if (qName.equalsIgnoreCase(GRAPH)) {
            this.graph.setVertex(this.vertex);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String resul_dimen;
        super.startElement(uri, localName, qName, attributes);
        if (qName.equalsIgnoreCase(EDGE)) {
            long vertex1 = Long.parseLong(attributes.getValue(SOURCE));
            long vertex2 = Long.parseLong(attributes.getValue(TARGET));
            float length = -1.0f;
            String aux_len = attributes.getValue(LENGTH);
            if (aux_len != null) {
                length = Float.parseFloat(aux_len);
            }
            Vertex v1 = this.vertexIndex.get(vertex1);
            Vertex v2 = this.vertexIndex.get(vertex2);
            this.edges.add(new Edge(length, v1, v2));
        } else if (qName.equalsIgnoreCase(SCALAR)) {
            String name = attributes.getValue(NAME);
            String value = attributes.getValue(VALUE);
            if (name != null && value != null) {
                Scalar s = this.graph.addScalar(name);
                this.tempVertex.setScalar(s, Float.parseFloat(value));
            }
        } else if (qName.equalsIgnoreCase(LABEL)) {
            String name = attributes.getValue(NAME);
            String value = attributes.getValue(VALUE);
            if (name != null && value != null) {
                int index = this.graph.addTitle(name);
                this.tempVertex.setTitle(index, value);
            }
        } else if (qName.equalsIgnoreCase(VERTEX)) {
            String id = attributes.getValue(ID);
            this.tempVertex = new Vertex(Long.parseLong(id));
        } else if (qName.equalsIgnoreCase(VALID)) {
            String value = attributes.getValue(VALUE);
            if (value != null) {
                this.tempVertex.setValid(value.equals("1"));
            }
        } else if (qName.equalsIgnoreCase(X_COORDINATE)) {
            String value = attributes.getValue(VALUE);
            if (value != null) {
                this.tempVertex.setX(Float.parseFloat(value));
            }
        } else if (qName.equalsIgnoreCase(Y_COORDINATE)) {
            String value = attributes.getValue(VALUE);
            if (value != null) {
                this.tempVertex.setY(Float.parseFloat(value));
            }
        } else if (qName.equalsIgnoreCase(URL)) {
            String value = attributes.getValue(VALUE);
            if (value != null) {
                this.tempVertex.setUrl(value);
            }
        } else if (qName.equalsIgnoreCase(EDGES)) {
            this.vertexIndex = new HashMap();
            for (Vertex v : this.vertex) {
                this.vertexIndex.put(v.getId(), v);
            }
            this.con = new Connectivity(attributes.getValue(NAME));
            this.edges = new ArrayList();
        } else if (qName.equalsIgnoreCase(GRAPH)) {
            String description = attributes.getValue(DESCRIPTION);
            if (description != null && description.trim().length() > 0) {
                this.graph.setDescription(description);
            }
            this.vertex = new ArrayList();
        } else if (qName.equalsIgnoreCase(SOURCE_TYPE)) {
            String src_type = attributes.getValue(VALUE);
            if (src_type != null) {
                this.graph.getProjectionData().setSourceType(SourceType.retrieve(src_type));
            }
        } else if (qName.equalsIgnoreCase(PROJECTION_TECHNIQUE)) {
            String proj_tech = attributes.getValue(VALUE);
            if (proj_tech != null) {
                this.graph.getProjectionData().setProjectionType(ProjectionType.retrieve(proj_tech));
            }
        } else if (qName.equalsIgnoreCase(DISTANCE_TYPE)) {
            String dist_type = attributes.getValue(VALUE);
            if (dist_type != null) {
                this.graph.getProjectionData().setDissimilarityType(DissimilarityType.retrieve(dist_type));
            }
        } else if (qName.equalsIgnoreCase(SOURCE_FILE)) {
            String src_file = attributes.getValue(VALUE);
            if (src_file != null) {
                this.graph.getProjectionData().setSourceFile(src_file);
                if (src_file.startsWith("google/")) {
                    ZipCorpus cp = new ZipCorpus(src_file, this.graph.getProjectionData().getNumberGrams());
                    this.graph.setCorpus(cp);
                }
            }
        } else if (qName.equalsIgnoreCase(NUMBER_ITERATIONS)) {
            String numb_it = attributes.getValue(VALUE);
            if (numb_it != null) {
                this.graph.getProjectionData().setNumberIterations(Integer.parseInt(numb_it));
            }
        } else if (qName.equalsIgnoreCase(FRACTION_DELTA)) {
            String frac_delta = attributes.getValue(VALUE);
            if (frac_delta != null) {
                this.graph.getProjectionData().setFractionDelta(Float.parseFloat(frac_delta));
            }
        } else if (qName.equalsIgnoreCase(PROJECTION_TYPE)) {
            String proj_type = attributes.getValue(VALUE);
            if (proj_type != null) {
                this.graph.getProjectionData().setProjectorType(ProjectorType.retrieve(proj_type));
            }
        } else if (qName.equalsIgnoreCase(LUHN_LOWER_CUT)) {
            String luhn_lw_cut = attributes.getValue(VALUE);
            if (luhn_lw_cut != null) {
                this.graph.getProjectionData().setLunhLowerCut(Integer.parseInt(luhn_lw_cut));
            }
        } else if (qName.equalsIgnoreCase(LUHN_UPPER_CUT)) {
            String luhn_up_cut = attributes.getValue(VALUE);
            if (luhn_up_cut != null) {
                this.graph.getProjectionData().setLunhUpperCut(Integer.parseInt(luhn_up_cut));
            }
        } else if (qName.equalsIgnoreCase(NUMBER_GRAMS)) {
            String numb_grams = attributes.getValue(VALUE);
            if (numb_grams != null) {
                this.graph.getProjectionData().setNumberGrams(Integer.parseInt(numb_grams));
            }
        } else if (qName.equalsIgnoreCase(COMPRESSOR_TYPE)) {
            String comp_type = attributes.getValue(VALUE);
            if (comp_type != null) {
                this.graph.getProjectionData().setCompressorType(CompressorType.retrieve(comp_type));
            }
        } else if (qName.equalsIgnoreCase(CLUSTER_FACTOR)) {
            String clust_factor = attributes.getValue(VALUE);
            if (clust_factor != null) {
                this.graph.getProjectionData().setClusterFactor(Float.parseFloat(clust_factor));
            }
        } else if (qName.equalsIgnoreCase(NUMBER_NEIGHBORS)) {
            String numb_neigh = attributes.getValue(VALUE);
            if (numb_neigh != null) {
                this.graph.getProjectionData().setNumberNeighborsConnection(Integer.parseInt(numb_neigh));
            }
        } else if (qName.equalsIgnoreCase(NUMBER_CONTROL_POINTS)) {
            String numb_cp = attributes.getValue(VALUE);
            if (numb_cp != null) {
                this.graph.getProjectionData().setNumberControlPoints(Integer.parseInt(numb_cp));
            }
        } else if (qName.equalsIgnoreCase(NUMBER_OBJECTS)) {
            String numb_objects = attributes.getValue(VALUE);
            if (numb_objects != null) {
                this.graph.getProjectionData().setNumberObjects(Integer.parseInt(numb_objects));
            }
        } else if (qName.equalsIgnoreCase(NUMBER_DIMENSIONS)) {
            String numb_dimen = attributes.getValue(VALUE);
            if (numb_dimen != null) {
                this.graph.getProjectionData().setNumberDimensions(Integer.parseInt(numb_dimen));
            }
        } else if (qName.equalsIgnoreCase(DIMEN_REDUCTION)) {
            String dimen_red = attributes.getValue(VALUE);
            if (dimen_red != null) {
                this.graph.getProjectionData().setDimensionReductionType(DimensionalityReductionType.retrieve(dimen_red));
            }
        } else if (qName.equalsIgnoreCase(RESULTING_DIMEN) && (resul_dimen = attributes.getValue(VALUE)) != null) {
            this.graph.getProjectionData().setTargetDimension(Integer.parseInt(resul_dimen));
        }
    }
}

