/*
 * Decompiled with CFR 0.152.
 */
package visualizer.graph.listeners;

import java.awt.Color;
import java.util.ArrayList;
import visualizer.graph.Vertex;
import visualizer.graph.listeners.VertexSelectionListener;
import visualizer.util.OpenDialog;
import visualizer.view.MultipleFileView;
import visualizer.view.MultipleImageView;
import visualizer.view.Viewer;

public class ViewContentSelectionListener
extends VertexSelectionListener {
    public ViewContentSelectionListener(Viewer panel) {
        super(panel);
        this.color = Color.GREEN;
    }

    @Override
    public ArrayList<Vertex> vertexSelected(Object param, ArrayList<Vertex> vertex) {
        Vertex v;
        if (vertex.size() > 0 && (v = vertex.get(0)).isValid()) {
            if (v.getUrl().endsWith("txt")) {
                if (OpenDialog.checkCorpus(this.panel.getGraph(), this.panel.getProjectionExplorerView())) {
                    MultipleFileView.getInstance(this.panel.getProjectionExplorerView()).display(this.panel, vertex);
                }
            } else if (OpenDialog.checkImages(this.panel.getGraph(), this.panel.getProjectionExplorerView())) {
                MultipleImageView.getInstance(this.panel.getProjectionExplorerView()).display(this.panel, vertex);
            }
        }
        return null;
    }
}

