/*
 * Decompiled with CFR 0.152.
 */
package visualizer.graph.scalar;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Stack;
import visualizer.corpus.Corpus;
import visualizer.graph.Scalar;
import visualizer.graph.Vertex;
import visualizer.textprocessing.Ngram;

public class QuerySolver {
    protected ArrayList<Vertex> vertex;
    private boolean entry = false;
    protected Corpus corpus;
    public static final String splitSymbol = "&";
    public static final char splitSymbolChar = '&';

    public QuerySolver(Corpus corpus, ArrayList<Vertex> vertex) {
        this.corpus = corpus;
        this.vertex = vertex;
    }

    public boolean isoperand(String symb) {
        symb.replaceAll(" ", "");
        return !symb.equals("and") && !symb.equals("or") && !symb.equals("(") && !symb.equals(")");
    }

    public boolean prdc(String one, String two) {
        if (one.equals("(")) {
            return false;
        }
        if (!one.equals(")") && two.equals("(")) {
            return false;
        }
        if (!one.equals("(") && two.equals(")")) {
            return true;
        }
        if (one.equals("and") && two.equals("or")) {
            return true;
        }
        if (one.equals("or") && two.equals("and")) {
            return false;
        }
        if (one.equals(two)) {
            return true;
        }
        return true;
    }

    public static String replaceCharAt(String s, int pos, char c) {
        return s.substring(0, pos) + c + s.substring(pos + 1);
    }

    public String postfix(String query) {
        boolean outpos = false;
        String topsymb = "or";
        StringBuffer postr = new StringBuffer();
        Stack<String> opstk = new Stack<String>();
        query = query.trim();
        query = query.replaceAll("\\(", " \\( ");
        query = query.replaceAll("\\)", " \\) ");
        boolean inSet = false;
        for (int i = 0; i < query.length(); ++i) {
            if (query.charAt(i) == '\"') {
                inSet = !inSet;
                continue;
            }
            if (inSet || query.charAt(i) != ' ') continue;
            query = QuerySolver.replaceCharAt(query, i, '&');
        }
        String[] symbs = query.split(splitSymbol);
        for (int i = 0; i < symbs.length; ++i) {
            boolean und;
            symbs[i] = symbs[i].replaceAll("\"", "");
            if (this.isoperand(symbs[i])) {
                postr.append(symbs[i] + splitSymbol);
                continue;
            }
            if (!opstk.empty()) {
                und = false;
                topsymb = (String)opstk.pop();
            } else {
                und = true;
            }
            while (!und && this.prdc(topsymb, symbs[i])) {
                postr.append(topsymb + splitSymbol);
                if (!opstk.empty()) {
                    und = false;
                    topsymb = (String)opstk.pop();
                    continue;
                }
                und = true;
            }
            if (!und) {
                opstk.push(topsymb);
            }
            if (und || !symbs[i].equals(")")) {
                opstk.push(symbs[i]);
                continue;
            }
            topsymb = (String)opstk.pop();
        }
        while (!opstk.empty()) {
            postr.append((String)opstk.pop() + splitSymbol);
        }
        return postr.toString();
    }

    protected float[] oper(String opr, float[] cdata1, float[] cdata2) {
        float[] cdata = new float[this.vertex.size()];
        for (int i = 0; i < cdata1.length; ++i) {
            cdata[i] = (cdata1[i] + cdata2[i]) / 2.0f;
            if (!opr.equals("and") || cdata1[i] != 0.0f && cdata2[i] != 0.0f) continue;
            cdata[i] = 0.0f;
        }
        return cdata;
    }

    float[] value(String word) throws IOException {
        float[] cdata = new float[this.vertex.size()];
        Arrays.fill(cdata, 0.0f);
        for (int i = 0; i < this.vertex.size(); ++i) {
            if (!this.vertex.get(i).isValid()) continue;
            cdata[i] = this.getWordFrequency(word, this.vertex.get(i).getUrl());
        }
        return cdata;
    }

    float[] eval(String postFix) throws IOException {
        Stack<float[]> opndstk = new Stack<float[]>();
        String[] symbs = postFix.split(splitSymbol);
        for (int i = 0; i < symbs.length; ++i) {
            if (symbs[i].equals("")) continue;
            if (this.isoperand(symbs[i])) {
                opndstk.push(this.value(symbs[i]));
                continue;
            }
            float[] opnd2 = (float[])opndstk.pop();
            float[] opnd1 = (float[])opndstk.pop();
            float[] value = this.oper(symbs[i], opnd1, opnd2);
            opndstk.push(value);
        }
        return (float[])opndstk.pop();
    }

    public void createCdata(String query, Scalar scalar) throws IOException {
        int i;
        if (this.corpus == null) {
            throw new IOException("The corpus must be loaded!");
        }
        this.entry = this.corpus == null;
        float[] cdata = this.eval(this.postfix(query));
        float max = 0.0f;
        float min = 1.0E11f;
        float numberOcurrences = 0.0f;
        for (i = 0; i < this.vertex.size(); ++i) {
            if (cdata[i] > max) {
                max = cdata[i];
            } else if (cdata[i] < min) {
                min = cdata[i];
            }
            if (!(cdata[i] > 0.0f)) continue;
            numberOcurrences += 1.0f;
        }
        for (i = 0; i < cdata.length; ++i) {
            cdata[i] = (double)(max - min) > 0.0 && cdata[i] >= numberOcurrences / (float)this.vertex.size() ? (cdata[i] - min) / (max - min) : 0.0f;
        }
        for (i = 0; i < this.vertex.size(); ++i) {
            this.vertex.get(i).setScalar(scalar, cdata[i]);
        }
    }

    private float getWordFrequency(String word, String filename) throws IOException {
        return this.getWordFrequencyFromFile(word, filename);
    }

    protected float getWordFrequencyFromFile(String word, String filename) throws IOException {
        float frequency = 0.0f;
        ArrayList<Ngram> ngrams = this.corpus.getNgrams(filename);
        for (Ngram n : ngrams) {
            if (n.ngram.indexOf(word.toLowerCase()) == -1) continue;
            frequency += (float)n.frequency;
        }
        return frequency;
    }

    public static void main(String[] args) {
    }
}

