/*
 * Decompiled with CFR 0.152.
 */
package visualizer.graph.scalar;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import visualizer.corpus.Corpus;
import visualizer.graph.Vertex;
import visualizer.graph.scalar.QuerySolver;

public class QuerySolverMatrix
extends QuerySolver {
    HashMap<String, Float> freqTable = new HashMap();
    HashMap<String, String> stemTable = new HashMap();
    HashMap<String, Integer> corporaNgrams;
    float[][] points;
    HashMap<String, Integer> pointLine = new HashMap();
    HashMap<String, Integer> wordLine = new HashMap();

    public QuerySolverMatrix(Corpus corpora, ArrayList<Vertex> vertex, float[][] points, HashMap<String, Integer> corporaNgrams) {
        super(corpora, vertex);
        this.corporaNgrams = corporaNgrams;
        this.points = points;
        for (int i = 0; i < corpora.getIds().size(); ++i) {
            this.pointLine.put(corpora.getIds().get(i), new Integer(i));
        }
        Object[] ngrams = corporaNgrams.keySet().toArray();
        for (int i = 0; i < ngrams.length; ++i) {
            this.wordLine.put((String)ngrams[i], new Integer(i));
        }
    }

    @Override
    protected float getWordFrequencyFromFile(String word, String filename) throws IOException {
        float frequency = 0.0f;
        if (this.wordLine.get(word + "<>") == null || this.pointLine.get(filename) == null) {
            return frequency;
        }
        int i = this.pointLine.get(filename);
        int j = this.wordLine.get(word + "<>");
        frequency = this.points[i][j];
        return frequency;
    }

    @Override
    protected float[] oper(String opr, float[] cdata1, float[] cdata2) {
        float[] cdata = new float[this.vertex.size()];
        for (int i = 0; i < cdata1.length; ++i) {
            if (opr.equals("and")) {
                if (cdata1[i] == 0.0f || cdata2[i] == 0.0f) {
                    cdata[i] = 0.0f;
                    continue;
                }
                cdata[i] = 1.0f;
                continue;
            }
            cdata[i] = cdata1[i] + cdata2[i];
        }
        return cdata;
    }
}

