/*
 * Decompiled with CFR 0.152.
 */
package visualizer.matrix;

import java.io.BufferedWriter;
import java.io.IOException;
import visualizer.matrix.SparseVector;
import visualizer.matrix.Vector;

public class DenseVector
extends Vector {
    public DenseVector(float[] vector) {
        this.create(vector, null, 0.0f);
    }

    public DenseVector(float[] vector, String id) {
        this.create(vector, id, 0.0f);
    }

    public DenseVector(float[] vector, float klass) {
        this.create(vector, null, klass);
    }

    public DenseVector(float[] vector, String id, float klass) {
        this.create(vector, id, klass);
    }

    @Override
    public float dot(Vector vector) {
        assert (this.size == vector.size) : "ERROR: vectors of different sizes!";
        float dot = 0.0f;
        if (vector instanceof DenseVector) {
            int length = this.values.length;
            for (int i = 0; i < length; ++i) {
                dot += this.values[i] * vector.values[i];
            }
        } else {
            int length = ((SparseVector)vector).index.length;
            for (int i = 0; i < length; ++i) {
                dot += this.values[((SparseVector)vector).index[i]] * vector.values[i];
            }
        }
        return dot;
    }

    @Override
    public void normalize() {
        assert (this.norm() != 0.0f) : "ERROR: it is not possible to normalize a null vector!";
        if (this.norm() > 1.0E-5f) {
            int length = this.values.length;
            for (int i = 0; i < length; ++i) {
                this.values[i] = this.values[i] / this.norm();
            }
            this.norm = 1.0f;
        } else {
            this.norm = 0.0f;
        }
    }

    @Override
    public float[] toArray() {
        float[] array = new float[this.values.length];
        System.arraycopy(this.values, 0, array, 0, this.values.length);
        return array;
    }

    @Override
    public float getValue(int index) {
        assert (index <= this.size) : "ERROR: vector can not be null!";
        return this.values[index];
    }

    @Override
    public void setValue(int index, float value) {
        assert (index <= this.size) : "ERROR: vector can not be null!";
        this.updateNorm = true;
        this.values[index] = value;
    }

    @Override
    public void write(BufferedWriter out) throws IOException {
        out.write(this.id);
        out.write(";");
        for (int i = 0; i < this.values.length; ++i) {
            out.write(Float.toString(this.values[i]));
            out.write(";");
        }
        out.write(Float.toString(this.klass));
    }

    @Override
    protected void create(float[] vector, String id, float klass) {
        assert (vector != null) : "ERROR: vector can not be null!";
        this.values = vector;
        this.size = vector.length;
        this.id = id;
        this.klass = klass;
        this.updateNorm = true;
    }

    @Override
    protected void updateNorm() {
        this.norm = 0.0f;
        int length = this.values.length;
        for (int i = 0; i < length; ++i) {
            this.norm += this.values[i] * this.values[i];
        }
        this.norm = (float)Math.sqrt(this.norm);
        this.updateNorm = false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DenseVector clone = new DenseVector(new float[]{0.0f});
        clone.norm = this.norm;
        clone.size = this.size;
        clone.id = this.id;
        clone.klass = this.klass;
        if (this.values != null) {
            clone.values = new float[this.values.length];
            System.arraycopy(this.values, 0, clone.values, 0, this.values.length);
        }
        return clone;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DenseVector) {
            DenseVector dv = (DenseVector)obj;
            if (this.size != dv.size) {
                return false;
            }
            for (int i = 0; i < this.values.length; ++i) {
                if (!(Math.abs(this.values[i] - dv.values[i]) > 1.0E-5f)) continue;
                return false;
            }
            return Math.abs(dv.norm - this.norm) <= 1.0E-5f;
        }
        if (obj instanceof SparseVector) {
            SparseVector sv = (SparseVector)obj;
            if (this.size != sv.size) {
                return false;
            }
            float[] values_aux = sv.values;
            for (int i = 0; i < this.values.length; ++i) {
                if (!(Math.abs(this.values[i] - values_aux[i]) > 1.0E-5f)) continue;
                return false;
            }
            return Math.abs(sv.norm - this.norm) <= 1.0E-5f;
        }
        return false;
    }

    public int hashCode() {
        int result = 5 + (int)this.norm;
        result += 7 * this.size;
        result += 7 * (int)this.klass;
        return result += 3 * this.id.hashCode();
    }
}

