/*
 * Decompiled with CFR 0.152.
 */
package visualizer.matrix;

import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import visualizer.matrix.DenseMatrix;
import visualizer.matrix.DenseVector;
import visualizer.matrix.Matrix;
import visualizer.matrix.MatrixFactory;
import visualizer.matrix.SparseMatrix;
import visualizer.matrix.SparseVector;
import visualizer.matrix.Vector;

public class MatrixUtils {
    public static Vector mean(Matrix matrix) {
        assert (matrix.getRowCount() > 0) : "More than zero vectors must be used!";
        if (matrix instanceof SparseMatrix) {
            float[] mean = new float[matrix.getDimensions()];
            Arrays.fill(mean, 0.0f);
            int size = matrix.getRowCount();
            for (int i = 0; i < size; ++i) {
                int[] index = ((SparseVector)matrix.getRow(i)).getIndex();
                float[] values = matrix.getRow(i).getValues();
                for (int j = 0; j < index.length; ++j) {
                    int n = index[j];
                    mean[n] = mean[n] + values[j];
                }
            }
            for (int j = 0; j < mean.length; ++j) {
                mean[j] = mean[j] / (float)size;
            }
            return new SparseVector(mean);
        }
        if (matrix instanceof DenseMatrix) {
            float[] mean = new float[matrix.getDimensions()];
            Arrays.fill(mean, 0.0f);
            int size = matrix.getRowCount();
            for (int i = 0; i < size; ++i) {
                float[] values = matrix.getRow(i).getValues();
                for (int j = 0; j < values.length; ++j) {
                    int n = j;
                    mean[n] = mean[n] + values[j];
                }
            }
            for (int j = 0; j < mean.length; ++j) {
                mean[j] = mean[j] / (float)size;
            }
            return new DenseVector(mean);
        }
        return null;
    }

    public static SparseMatrix convert(DenseMatrix matrix) {
        SparseMatrix newmatrix = new SparseMatrix();
        newmatrix.setAttributes(matrix.getAttributes());
        for (int i = 0; i < matrix.getRowCount(); ++i) {
            Vector dv = matrix.getRow(i);
            newmatrix.addRow(new SparseVector(dv.toArray(), dv.getId(), dv.getKlass()));
        }
        return newmatrix;
    }

    public static DenseMatrix convert(SparseMatrix matrix) {
        DenseMatrix newmatrix = new DenseMatrix();
        newmatrix.setAttributes(matrix.getAttributes());
        for (int i = 0; i < matrix.getRowCount(); ++i) {
            Vector dv = matrix.getRow(i);
            newmatrix.addRow(new SparseVector(dv.toArray(), dv.getId(), dv.getKlass()));
        }
        return newmatrix;
    }

    public static void main(String[] args) {
        try {
            String filename = "C:\\Documents and Settings\\Fernando\\Mijn documenten\\dataset\\output3.data";
            Matrix matrix = MatrixFactory.getInstance(filename);
            SparseMatrix convert = MatrixUtils.convert((DenseMatrix)matrix);
            convert.save(filename + ".sp.data");
        }
        catch (IOException ex) {
            Logger.getLogger(MatrixUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

