/*
 * Decompiled with CFR 0.152.
 */
package visualizer.matrix.normalization;

import java.io.IOException;
import java.util.Arrays;
import visualizer.matrix.DenseMatrix;
import visualizer.matrix.DenseVector;
import visualizer.matrix.Matrix;
import visualizer.matrix.Vector;
import visualizer.matrix.normalization.Normalization;

public class Standardization
extends Normalization {
    @Override
    public Matrix execute(Matrix matrix) throws IOException {
        int j;
        int i;
        int j2;
        int i2;
        assert (matrix.getRowCount() > 0) : "More than zero vectors must be used!";
        float[][] points = matrix.toMatrix();
        double[] mean = new double[points[0].length];
        Arrays.fill(mean, 0.0);
        for (i2 = 0; i2 < points.length; ++i2) {
            for (j2 = 0; j2 < points[i2].length; ++j2) {
                int n = j2;
                mean[n] = mean[n] + (double)points[i2][j2];
            }
        }
        i2 = 0;
        while (i2 < mean.length) {
            int n = i2++;
            mean[n] = mean[n] / (double)points.length;
        }
        for (i2 = 0; i2 < points.length; ++i2) {
            for (j2 = 0; j2 < points[i2].length; ++j2) {
                float[] fArray = points[i2];
                int n = j2;
                fArray[n] = (float)((double)fArray[n] - mean[j2]);
            }
        }
        double[] deviation = new double[points[0].length];
        Arrays.fill(deviation, 0.0);
        for (i = 0; i < points.length; ++i) {
            for (j = 0; j < points[i].length; ++j) {
                int n = j;
                deviation[n] = deviation[n] + (double)(points[i][j] * points[i][j]);
            }
        }
        for (i = 0; i < mean.length; ++i) {
            deviation[i] = (float)Math.sqrt(deviation[i] / (double)(points.length - 1));
        }
        for (i = 0; i < points.length; ++i) {
            for (j = 0; j < points[i].length; ++j) {
                float[] fArray = points[i];
                int n = j;
                fArray[n] = (float)((double)fArray[n] / deviation[j]);
            }
        }
        DenseMatrix stdmatrix = new DenseMatrix();
        stdmatrix.setAttributes(matrix.getAttributes());
        for (int i3 = 0; i3 < matrix.getRowCount(); ++i3) {
            Vector oldv = matrix.getRow(i3);
            ((Matrix)stdmatrix).addRow(new DenseVector(points[i3], oldv.getId(), oldv.getKlass()));
        }
        return stdmatrix;
    }
}

