/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection;

import java.util.logging.Level;
import java.util.logging.Logger;
import visualizer.projection.Projector;
import visualizer.projection.distance.DistanceMatrix;

public class FastmapProjection
extends Projector {
    private int targetDimension;

    public FastmapProjection() {
        this.targetDimension = 2;
    }

    public FastmapProjection(int targetDimension) {
        this.targetDimension = targetDimension;
    }

    @Override
    public float[][] project(DistanceMatrix dmat) {
        Object points = null;
        try {
            dmat = (DistanceMatrix)dmat.clone();
            points = new float[dmat.getElementCount()][];
            for (int i = 0; i < dmat.getElementCount(); ++i) {
                points[i] = new float[this.targetDimension];
            }
            if (((float[][])points).length < 4) {
                this.doTheFastmapLessThan4Points((float[][])points, dmat);
            } else {
                this.doTheFastmap((float[][])points, dmat);
            }
            this.normalize((float[][])points);
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
        return points;
    }

    public void doTheFastmapLessThan4Points(float[][] points, DistanceMatrix dmat) {
        if (points.length == 1) {
            points[0][0] = 0.0f;
            points[0][1] = 0.0f;
        } else if (points.length == 2) {
            points[0][0] = 0.0f;
            points[0][1] = 0.0f;
            points[1][0] = dmat.getDistance(0, 1);
            points[1][1] = 0.0f;
        } else if (points.length == 3) {
            points[0][0] = 0.0f;
            points[0][1] = 0.0f;
            points[1][0] = dmat.getDistance(0, 1);
            points[1][1] = 0.0f;
            points[2][0] = dmat.getDistance(0, 1);
            points[2][1] = dmat.getDistance(1, 2);
        }
    }

    private void doTheFastmap(float[][] points, DistanceMatrix dmat) {
        for (int currentDimension = 0; currentDimension < this.targetDimension; ++currentDimension) {
            int lvi;
            int[] lvchoosen = this.chooseDistantObjects(dmat);
            float lvdistance = dmat.getDistance(lvchoosen[0], lvchoosen[1]);
            if (lvdistance == 0.0f) {
                for (lvi = 0; lvi < dmat.getElementCount(); ++lvi) {
                    points[lvi][currentDimension] = 0.0f;
                }
                continue;
            }
            for (lvi = 0; lvi < dmat.getElementCount(); ++lvi) {
                float lvxi;
                points[lvi][currentDimension] = lvxi = (float)((Math.pow(dmat.getDistance(lvchoosen[0], lvi), 2.0) + Math.pow(dmat.getDistance(lvchoosen[0], lvchoosen[1]), 2.0) - Math.pow(dmat.getDistance(lvi, lvchoosen[1]), 2.0)) / (double)(2.0f * dmat.getDistance(lvchoosen[0], lvchoosen[1])));
            }
            if (currentDimension >= this.targetDimension - 1) continue;
            this.updateDistances(dmat, points, currentDimension);
        }
    }

    private int[] chooseDistantObjects(DistanceMatrix dmat) {
        int[] choosen = new int[2];
        int x = 0;
        int y = 1;
        for (int i = 0; i < dmat.getElementCount() - 1; ++i) {
            for (int j = i + 1; j < dmat.getElementCount(); ++j) {
                if (!(dmat.getDistance(x, y) < dmat.getDistance(i, j))) continue;
                x = i;
                y = j;
            }
        }
        choosen[0] = x;
        choosen[1] = y;
        return choosen;
    }

    private void updateDistances(DistanceMatrix dmat, float[][] points, int currentDimension) {
        for (int lvinst = 0; lvinst < dmat.getElementCount(); ++lvinst) {
            for (int lvinst2 = lvinst + 1; lvinst2 < dmat.getElementCount(); ++lvinst2) {
                float value = (float)Math.sqrt(Math.abs(Math.pow(dmat.getDistance(lvinst, lvinst2), 2.0) - Math.pow(points[lvinst][currentDimension] - points[lvinst2][currentDimension], 2.0)));
                dmat.setDistance(lvinst, lvinst2, value);
            }
        }
    }
}

