/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import visualizer.graph.Connectivity;
import visualizer.graph.Graph;
import visualizer.matrix.DenseMatrix;
import visualizer.matrix.DenseVector;
import visualizer.matrix.Matrix;
import visualizer.projection.ProjectionData;
import visualizer.projection.distance.DistanceMatrix;
import visualizer.projection.distance.Euclidean;
import visualizer.util.ApproxKNN;
import visualizer.util.Delaunay;
import visualizer.util.Pair;
import visualizer.wizard.ProjectionView;

public abstract class Projection {
    protected Pair[][] knnneighbors;
    protected DistanceMatrix dmat;

    public abstract float[][] project(Matrix var1, ProjectionData var2, ProjectionView var3);

    public abstract float[][] project(DistanceMatrix var1, ProjectionData var2, ProjectionView var3);

    public abstract ProjectionView getProjectionView(ProjectionData var1);

    public void postProcessing(Graph graph) {
    }

    public void createConnectivities(Graph graph, ProjectionData pdata, ProjectionView view) {
        try {
            if (view != null) {
                view.setStatus("Creating the Delaunay triangulation...", 95);
            }
            float[][] projection = new float[graph.getVertex().size()][];
            for (int i = 0; i < projection.length; ++i) {
                projection[i] = new float[2];
                projection[i][0] = graph.getVertex().get(i).getX();
                projection[i][1] = graph.getVertex().get(i).getY();
            }
            if (pdata.isCreateDelaunay()) {
                graph.perturb();
                try {
                    Delaunay d = new Delaunay();
                    Pair[][] neighborhood = d.execute(projection);
                    Connectivity con = new Connectivity("Delaunay");
                    con.create(graph.getVertex(), neighborhood);
                    graph.addConnectivity(con);
                }
                catch (IllegalArgumentException ex) {
                    Logger.getLogger(Projection.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (pdata.getKnnNumberNeighbors() > 0) {
                if (view != null) {
                    view.setStatus("Creating the KNN-R2 connectivity...", 95);
                }
                DenseMatrix dproj = new DenseMatrix();
                for (int i = 0; i < projection.length; ++i) {
                    dproj.addRow(new DenseVector(projection[i]));
                }
                String conname = "KNN-R2-" + pdata.getKnnNumberNeighbors();
                Connectivity knnr2Con = new Connectivity(conname);
                ApproxKNN appknn = new ApproxKNN(pdata.getKnnNumberNeighbors());
                Pair[][] neighborhood = appknn.execute(dproj, new Euclidean());
                knnr2Con.create(graph.getVertex(), neighborhood);
                graph.addConnectivity(knnr2Con);
                if (this.knnneighbors != null) {
                    if (view != null) {
                        view.setStatus("Creating KNN connectivity...", 90);
                    }
                    conname = "KNN-RN-" + pdata.getKnnNumberNeighbors();
                    Connectivity knnrnCon = new Connectivity(conname);
                    knnrnCon.create(graph.getVertex(), this.knnneighbors);
                    graph.addConnectivity(knnrnCon);
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Projection.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public DistanceMatrix getDistanceMatrix() {
        return this.dmat;
    }
}

