/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection;

import visualizer.datamining.clustering.HierarchicalClusteringType;
import visualizer.dimensionreduction.DimensionalityReductionType;
import visualizer.matrix.normalization.NormalizationType;
import visualizer.projection.ProjectionType;
import visualizer.projection.ProjectorType;
import visualizer.projection.SourceType;
import visualizer.projection.distance.DissimilarityType;
import visualizer.projection.distance.kolmogorov.CompressorType;
import visualizer.projection.lsp.ControlPointsType;
import visualizer.textprocessing.stemmer.StemmerType;
import visualizer.textprocessing.transformation.MatrixTransformationType;

public class ProjectionData {
    private SourceType source = SourceType.NONE;
    private DissimilarityType distanceType = DissimilarityType.NONE;
    private ProjectionType projTech = ProjectionType.NONE;
    private String sourceFile = "";
    private String titlesFile = "";
    private String dmatFilename = "";
    private String docsTermsFilename = "";
    private int numberIterations = 50;
    private float fractionDelta = 8.0f;
    private ProjectorType projector = ProjectorType.NONE;
    private int knnNumberNeighbors = 2;
    private boolean createDelaunay = true;
    private String description = "";
    private HierarchicalClusteringType hierarchicalClusteringType = HierarchicalClusteringType.NONE;
    private int lunhLowerCut = 10;
    private int lunhUpperCut = -1;
    private int numberLines = 0;
    private int numberGrams = 1;
    private MatrixTransformationType mattype = MatrixTransformationType.TF_IDF;
    private StemmerType stemmer = StemmerType.PORTER;
    private boolean useStopword = true;
    private boolean useWeight = false;
    private CompressorType comptype = CompressorType.BZIP2;
    private float clusterFactor = 4.5f;
    private int numberNeighborsConnection = 10;
    private int numberControlPoint = 10;
    private ControlPointsType controlPointsChoice = ControlPointsType.KMEDOIDS;
    private int numberObjects = 0;
    private int numberDimensions = 0;
    private int targetDimension = 0;
    private DimensionalityReductionType dimenType = DimensionalityReductionType.NONE;
    private NormalizationType normalization = NormalizationType.NONE;

    public SourceType getSourceType() {
        return this.source;
    }

    public void setSourceType(SourceType source) {
        this.source = source;
    }

    public ProjectionType getProjectionType() {
        return this.projTech;
    }

    public void setProjectionType(ProjectionType projTech) {
        this.projTech = projTech;
    }

    public DissimilarityType getDissimilarityType() {
        return this.distanceType;
    }

    public void setDissimilarityType(DissimilarityType distanceType) {
        this.distanceType = distanceType;
    }

    public ProjectorType getProjectorType() {
        return this.projector;
    }

    public void setProjectorType(ProjectorType projector) {
        this.projector = projector;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    public int getLunhLowerCut() {
        return this.lunhLowerCut;
    }

    public void setLunhLowerCut(int lunhLowerCut) {
        this.lunhLowerCut = lunhLowerCut;
    }

    public int getLunhUpperCut() {
        return this.lunhUpperCut;
    }

    public void setLunhUpperCut(int lunhUpperCut) {
        this.lunhUpperCut = lunhUpperCut;
    }

    public int getNumberLines() {
        return this.numberLines;
    }

    public void setNumberLines(int numberLines) {
        this.numberLines = numberLines;
    }

    public int getNumberIterations() {
        return this.numberIterations;
    }

    public void setNumberIterations(int numberIterations) {
        this.numberIterations = numberIterations;
    }

    public float getFractionDelta() {
        return this.fractionDelta;
    }

    public void setFractionDelta(float fractionDelta) {
        this.fractionDelta = fractionDelta;
    }

    public float getClusterFactor() {
        return this.clusterFactor;
    }

    public void setClusterFactor(float clusterFactor) {
        this.clusterFactor = clusterFactor;
    }

    public int getNumberGrams() {
        return this.numberGrams;
    }

    public void setNumberGrams(int numberGrams) {
        this.numberGrams = numberGrams;
    }

    public int getKnnNumberNeighbors() {
        return this.knnNumberNeighbors;
    }

    public void setKnnNumberNeighbors(int knnNumberNeighbors) {
        this.knnNumberNeighbors = knnNumberNeighbors;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getNumberNeighborsConnection() {
        return this.numberNeighborsConnection;
    }

    public void setNumberNeighborsConnection(int numberNeighborsConnection) {
        this.numberNeighborsConnection = numberNeighborsConnection;
    }

    public int getNumberControlPoints() {
        return this.numberControlPoint;
    }

    public void setNumberControlPoints(int numberControlPoint) {
        this.numberControlPoint = numberControlPoint;
    }

    public ControlPointsType getControlPointsChoice() {
        return this.controlPointsChoice;
    }

    public void setControlPointsChoice(ControlPointsType controlPointsChoice) {
        this.controlPointsChoice = controlPointsChoice;
    }

    public CompressorType getCompressorType() {
        return this.comptype;
    }

    public void setCompressorType(CompressorType comptype) {
        this.comptype = comptype;
    }

    public String getDistanceMatrixFilename() {
        return this.dmatFilename;
    }

    public void setDistanceMatrixFilename(String dmatFilename) {
        this.dmatFilename = dmatFilename;
    }

    public int getNumberObjects() {
        return this.numberObjects;
    }

    public void setNumberObjects(int numberObjects) {
        this.numberObjects = numberObjects;
    }

    public int getNumberDimensions() {
        return this.numberDimensions;
    }

    public void setNumberDimensions(int numberDimensions) {
        this.numberDimensions = numberDimensions;
    }

    public String getDocsTermsFilename() {
        return this.docsTermsFilename;
    }

    public void setDocsTermsFilename(String docsTermsFilename) {
        this.docsTermsFilename = docsTermsFilename;
    }

    public HierarchicalClusteringType getHierarchicalClusteringType() {
        return this.hierarchicalClusteringType;
    }

    public void setHierarchicalClusteringType(HierarchicalClusteringType hierarchicalClusteringType) {
        this.hierarchicalClusteringType = hierarchicalClusteringType;
    }

    public String getTitlesFile() {
        return this.titlesFile;
    }

    public void setTitlesFile(String titlesFile) {
        this.titlesFile = titlesFile;
    }

    public MatrixTransformationType getMatrixTransformationType() {
        return this.mattype;
    }

    public void setMatrixTransformationType(MatrixTransformationType mattype) {
        this.mattype = mattype;
    }

    public StemmerType getStemmer() {
        return this.stemmer;
    }

    public void setStemmer(StemmerType stemmer) {
        this.stemmer = stemmer;
    }

    public boolean isUseStopword() {
        return this.useStopword;
    }

    public boolean isUseWeight() {
        return this.useWeight;
    }

    public void setUseWeight(boolean useWeight) {
        this.useWeight = useWeight;
    }

    public void setUseStopword(boolean useStopword) {
        this.useStopword = useStopword;
    }

    public int getTargetDimension() {
        return this.targetDimension;
    }

    public void setTargetDimension(int targetDimension) {
        this.targetDimension = targetDimension;
    }

    public DimensionalityReductionType getDimensionReductionType() {
        return this.dimenType;
    }

    public void setDimensionReductionType(DimensionalityReductionType dimenType) {
        this.dimenType = dimenType;
    }

    public NormalizationType getNormalization() {
        return this.normalization;
    }

    public void setNormalization(NormalizationType normalization) {
        this.normalization = normalization;
    }

    public boolean isCreateDelaunay() {
        return this.createDelaunay;
    }

    public void setCreateDelaunay(boolean createDelaunay) {
        this.createDelaunay = createDelaunay;
    }

    public Object clone() throws CloneNotSupportedException {
        ProjectionData pdata = new ProjectionData();
        pdata.source = this.source;
        pdata.projTech = this.projTech;
        pdata.distanceType = this.distanceType;
        pdata.sourceFile = this.sourceFile;
        pdata.titlesFile = this.titlesFile;
        pdata.numberIterations = this.numberIterations;
        pdata.fractionDelta = this.fractionDelta;
        pdata.projector = this.projector;
        pdata.knnNumberNeighbors = this.knnNumberNeighbors;
        pdata.description = this.description;
        pdata.hierarchicalClusteringType = this.hierarchicalClusteringType;
        pdata.dmatFilename = this.dmatFilename;
        pdata.docsTermsFilename = this.docsTermsFilename;
        pdata.lunhLowerCut = this.lunhLowerCut;
        pdata.lunhUpperCut = this.lunhUpperCut;
        pdata.numberLines = this.numberLines;
        pdata.numberGrams = this.numberGrams;
        pdata.mattype = this.mattype;
        pdata.comptype = this.comptype;
        pdata.clusterFactor = this.clusterFactor;
        pdata.numberNeighborsConnection = this.numberNeighborsConnection;
        pdata.numberControlPoint = this.numberControlPoint;
        pdata.controlPointsChoice = this.controlPointsChoice;
        pdata.numberObjects = this.numberObjects;
        pdata.numberDimensions = this.numberDimensions;
        pdata.useStopword = this.useStopword;
        pdata.targetDimension = this.targetDimension;
        pdata.useWeight = this.useWeight;
        pdata.dimenType = this.dimenType;
        pdata.normalization = this.normalization;
        pdata.createDelaunay = this.createDelaunay;
        pdata.stemmer = this.stemmer;
        return pdata;
    }
}

