/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection.distance.kolmogorov;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import visualizer.corpus.Corpus;
import visualizer.corpus.zip.ZipCorpus;
import visualizer.projection.distance.DistanceMatrix;
import visualizer.projection.distance.kolmogorov.CompressorType;
import visualizer.projection.distance.kolmogorov.NormalCompressDistance;
import visualizer.wizard.ProjectionView;

public class NcdDistanceMatrixFactory {
    public static DistanceMatrix getInstance(ProjectionView view, CompressorType compType, Corpus corpus) {
        if (view != null) {
            view.setStatus("Calculating distances using NCD..." + corpus.getUrl(), 6);
        }
        int size = corpus.getIds().size();
        NormalCompressDistance ncd = new NormalCompressDistance(compType, corpus);
        DistanceMatrix dmat = new DistanceMatrix(size);
        dmat.setIds(corpus.getIds());
        dmat.setClassData(corpus.getClassData());
        for (int i = 0; i < size; ++i) {
            for (int j = i + 1; j < size; ++j) {
                dmat.setDistance(i, j, ncd.calculateNewNCD(i, j));
            }
            if (view == null) continue;
            view.setStatus("Calculating distances using NCD...", (int)(30.0f / (float)size * (float)i + 6.0f));
        }
        return dmat;
    }

    public static void main(String[] args) {
        try {
            String filename = "cbr-ilp-ir.dmat";
            String url = "G:\\User\\users\\Documents\\FERNANDO\\Corpora\\cbr-ilp-ir.zip";
            ZipCorpus corpus = new ZipCorpus(url, 1);
            DistanceMatrix dmat = NcdDistanceMatrixFactory.getInstance(null, CompressorType.BZIP2, corpus);
            dmat.save(filename);
        }
        catch (IOException ex) {
            Logger.getLogger(NcdDistanceMatrixFactory.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

