/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection.distance.kolmogorov;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import visualizer.corpus.Corpus;
import visualizer.projection.distance.kolmogorov.CompressorType;
import visualizer.util.LZOCompressor;

public class NormalCompressDistance {
    private Corpus corpus;
    private ArrayList<String> filenames = new ArrayList();
    private CompressorType comptype = CompressorType.BZIP2;
    private ArrayList<Long> c = new ArrayList();
    private ArrayList<Float> ncdXX = new ArrayList();

    public NormalCompressDistance(CompressorType comptype, Corpus corpus) {
        this.comptype = comptype;
        this.corpus = corpus;
        this.filenames = this.corpus.getIds();
    }

    public float calculateNewNCD(int filenameIndex1, int filenameIndex2) {
        if (this.c.isEmpty() && this.ncdXX.isEmpty()) {
            this.calculateAllC();
            this.calculateAllNcdXX();
        }
        float ncd = this.calculateNCD(filenameIndex1, filenameIndex2);
        float cxx = this.ncdXX.get(filenameIndex1).floatValue();
        float cyy = this.ncdXX.get(filenameIndex2).floatValue();
        return ncd - (cxx + cyy) / 2.0f;
    }

    public float calculateNewNCD(String filename1, String filename2) {
        float ncd = this.calculateNCD(filename1, filename2);
        float cxx = this.calculateNCD(filename1, filename1);
        float cyy = this.calculateNCD(filename2, filename2);
        return ncd - (cxx + cyy) / 2.0f;
    }

    public float calculateNCD(int filenameIndex1, int filenameIndex2) {
        if (this.c.isEmpty()) {
            this.calculateAllC();
        }
        long cx = this.c.get(filenameIndex1);
        long cy = this.c.get(filenameIndex2);
        long cxy = this.calculateCombinedC(this.filenames.get(filenameIndex1), this.filenames.get(filenameIndex2));
        return (float)(cxy - Math.min(cx, cy)) / (float)Math.max(cx, cy);
    }

    public float calculateNCD(String filename1, String filename2) {
        long cx = this.calculateC(filename1);
        long cy = this.calculateC(filename2);
        long cxy = this.calculateCombinedC(filename1, filename2);
        return (float)(cxy - Math.min(cx, cy)) / (float)Math.max(cx, cy);
    }

    protected long calculateC(String filename) {
        try {
            ByteArrayOutputStream dest = new ByteArrayOutputStream();
            OutputStream out = null;
            out = this.comptype == CompressorType.BZIP2 ? this.compressUsingZip(dest) : this.compressUsingGzip(dest);
            String tmp = "";
            tmp = tmp + this.corpus.getFullContent(filename);
            System.out.println(filename);
            if (out != null) {
                out.write(tmp.getBytes(), 0, tmp.length());
                out.flush();
                out.close();
            }
            if (this.comptype == CompressorType.LZO1) {
                return this.compressUsingLzo(tmp);
            }
            return dest.size();
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            return -1L;
        }
    }

    protected long calculateCombinedC(String filename1, String filename2) {
        try {
            ByteArrayOutputStream dest = new ByteArrayOutputStream();
            OutputStream out = null;
            out = this.comptype == CompressorType.BZIP2 ? this.compressUsingZip(dest) : this.compressUsingGzip(dest);
            String tmp = this.corpus.getFullContent(filename1) + " " + this.corpus.getFullContent(filename2);
            if (out != null) {
                out.write(tmp.getBytes(), 0, tmp.length());
                out.flush();
                out.close();
            }
            if (this.comptype == CompressorType.LZO1) {
                return this.compressUsingLzo(tmp);
            }
            return dest.size();
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            return -1L;
        }
    }

    protected void calculateAllC() {
        try {
            for (String filename : this.filenames) {
                ByteArrayOutputStream dest = new ByteArrayOutputStream();
                OutputStream out = null;
                out = this.comptype == CompressorType.BZIP2 ? this.compressUsingZip(dest) : this.compressUsingGzip(dest);
                String tmp = this.corpus.getFullContent(filename);
                if (out != null) {
                    out.write(tmp.getBytes(), 0, tmp.length());
                    out.flush();
                    out.close();
                }
                if (this.comptype == CompressorType.LZO1) {
                    this.c.add(this.compressUsingLzo(tmp));
                    continue;
                }
                this.c.add(Long.valueOf(dest.size()));
            }
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void calculateAllNcdXX() {
        for (String filename : this.filenames) {
            float xx = this.calculateNCD(filename, filename);
            this.ncdXX.add(Float.valueOf(xx));
        }
    }

    protected OutputStream compressUsingGzip(ByteArrayOutputStream dest) throws IOException {
        return new GZIPOutputStream(new BufferedOutputStream(dest));
    }

    protected OutputStream compressUsingZip(ByteArrayOutputStream dest) throws IOException {
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(dest));
        out.setMethod(8);
        ZipEntry entry = new ZipEntry("");
        out.putNextEntry(entry);
        return out;
    }

    protected long compressUsingLzo(String dest) throws IOException {
        LZOCompressor LZO = new LZOCompressor();
        return LZO.compressUsingLZO(dest);
    }
}

