/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection.isomap;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import visualizer.matrix.Matrix;
import visualizer.matrix.MatrixFactory;
import visualizer.projection.Projection;
import visualizer.projection.ProjectionData;
import visualizer.projection.distance.Dissimilarity;
import visualizer.projection.distance.DissimilarityFactory;
import visualizer.projection.distance.DissimilarityType;
import visualizer.projection.distance.DistanceMatrix;
import visualizer.projection.isomap.ISOMAPProjectionView;
import visualizer.projection.lsp.MeshGenerator;
import visualizer.projection.mds.ClassicalScalingProjection;
import visualizer.util.Dijkstra;
import visualizer.util.KNN;
import visualizer.util.Pair;
import visualizer.wizard.ProjectionView;

public class ISOMAPProjection
extends Projection {
    @Override
    public float[][] project(Matrix matrix, ProjectionData pdata, ProjectionView view) {
        try {
            Dissimilarity diss = DissimilarityFactory.getInstance(pdata.getDissimilarityType());
            DistanceMatrix dmat_aux = new DistanceMatrix(matrix, diss);
            dmat_aux.setIds(matrix.getIds());
            dmat_aux.setClassData(matrix.getClassData());
            return this.project(dmat_aux, pdata, view);
        }
        catch (IOException ex) {
            Logger.getLogger(ISOMAPProjection.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public float[][] project(DistanceMatrix dmat, ProjectionData pdata, ProjectionView view) {
        try {
            if (view != null) {
                view.setStatus("Creating the new distance matrix...", 40);
            }
            DistanceMatrix new_dmat = new DistanceMatrix(dmat.getElementCount());
            KNN knn = new KNN(pdata.getNumberNeighborsConnection());
            Pair[][] neighborhood = knn.execute(dmat);
            if (view != null) {
                view.setStatus("Creating the new distance matrix...", 50);
            }
            MeshGenerator meshgen = new MeshGenerator();
            neighborhood = meshgen.execute(neighborhood, dmat);
            if (view != null) {
                view.setStatus("Creating the new distance matrix...", 60);
            }
            Dijkstra d = new Dijkstra(neighborhood, dmat.getElementCount());
            for (int i = 0; i < dmat.getElementCount(); ++i) {
                float[] dist = d.execute(i);
                for (int j = 0; j < dist.length; ++j) {
                    new_dmat.setDistance(i, j, dist[j]);
                    assert (dist[j] == dist[j]);
                }
            }
            ClassicalScalingProjection cmds = new ClassicalScalingProjection();
            return cmds.project(new_dmat, pdata, view);
        }
        catch (IOException ex) {
            Logger.getLogger(ISOMAPProjection.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public ProjectionView getProjectionView(ProjectionData pdata) {
        return new ISOMAPProjectionView(pdata);
    }

    public static void main(String[] args) {
        try {
            String filename = "D:\\My Documents\\FERNANDO\\Tese\\datasets\\cbrilpirson.data";
            Matrix matrix = MatrixFactory.getInstance(filename);
            for (int i = 10; i <= 25; ++i) {
                BufferedWriter out = null;
                try {
                    out = new BufferedWriter(new FileWriter(filename + "_ISOMAP_" + i + ".prj"));
                    ProjectionData pdata = new ProjectionData();
                    pdata.setDissimilarityType(DissimilarityType.COSINE_BASED);
                    pdata.setNumberNeighborsConnection(i);
                    ISOMAPProjection lle = new ISOMAPProjection();
                    float[][] projection = lle.project(matrix, pdata, null);
                    out.write("x;y\r\n");
                    for (int j = 0; j < projection.length; ++j) {
                        out.write(matrix.getRow(j).getId());
                        out.write(";");
                        out.write(Float.toString(projection[j][0]));
                        out.write(";");
                        out.write(Float.toString(projection[j][1]));
                        out.write(";");
                        out.write(Float.toString(matrix.getRow(j).getKlass()));
                        out.write("\r\n");
                    }
                    continue;
                }
                catch (IOException e) {
                    throw new IOException(e.getMessage());
                }
                finally {
                    if (out != null) {
                        try {
                            out.flush();
                            out.close();
                        }
                        catch (IOException ex) {
                            Logger.getLogger(ISOMAPProjection.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ISOMAPProjection.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

