/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection.isomap;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import visualizer.projection.ProjectionData;
import visualizer.wizard.ProjectionView;

public class ISOMAPProjectionView
extends ProjectionView {
    private JPanel jPanel1;
    private JLabel nrNeighborsLabel;
    private JTextField nrNeighborsTextField;
    private JPanel parametersPanel;
    private JLabel statusLabel;
    private JPanel statusPanel;
    private JProgressBar statusProgressBar;

    public ISOMAPProjectionView(ProjectionData pdata) {
        super(pdata);
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.statusPanel = new JPanel();
        this.statusProgressBar = new JProgressBar();
        this.statusLabel = new JLabel();
        this.parametersPanel = new JPanel();
        this.nrNeighborsLabel = new JLabel();
        this.nrNeighborsTextField = new JTextField();
        this.setLayout(new BorderLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("ISOMAP"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.statusPanel.setBorder(BorderFactory.createTitledBorder("Status"));
        this.statusPanel.setLayout(new BorderLayout());
        this.statusProgressBar.setPreferredSize(new Dimension(350, 22));
        this.statusProgressBar.setStringPainted(true);
        this.statusPanel.add((Component)this.statusProgressBar, "South");
        this.statusLabel.setText("   ");
        this.statusLabel.setMinimumSize(new Dimension(100, 22));
        this.statusLabel.setPreferredSize(new Dimension(100, 22));
        this.statusPanel.add((Component)this.statusLabel, "North");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.statusPanel, gridBagConstraints);
        this.parametersPanel.setBorder(BorderFactory.createTitledBorder("Parameters"));
        this.nrNeighborsLabel.setText("Number of Neighbors");
        this.parametersPanel.add(this.nrNeighborsLabel);
        this.nrNeighborsTextField.setColumns(10);
        this.nrNeighborsTextField.setText("10");
        this.parametersPanel.add(this.nrNeighborsTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.parametersPanel, gridBagConstraints);
        this.add((Component)this.jPanel1, "Center");
    }

    @Override
    public void reset() {
        this.nrNeighborsTextField.setText(Integer.toString(this.pdata.getNumberNeighborsConnection()));
    }

    @Override
    public void setStatus(String status, int value) {
        this.statusLabel.setText(status);
        this.statusProgressBar.setValue(value);
    }

    @Override
    public void refreshData() {
        this.pdata.setNumberNeighborsConnection(Integer.parseInt(this.nrNeighborsTextField.getText()));
    }
}

