/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection.lle;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.EigenvalueDecomposition;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import visualizer.matrix.Matrix;
import visualizer.matrix.MatrixFactory;
import visualizer.projection.Projection;
import visualizer.projection.ProjectionData;
import visualizer.projection.distance.Dissimilarity;
import visualizer.projection.distance.DissimilarityFactory;
import visualizer.projection.distance.DissimilarityType;
import visualizer.projection.distance.DistanceMatrix;
import visualizer.projection.lle.LLEProjectionView;
import visualizer.util.KNN;
import visualizer.util.Pair;
import visualizer.wizard.ProjectionView;

public class LLEProjection
extends Projection {
    private static final float EPSILON = Float.MIN_VALUE;

    @Override
    public float[][] project(Matrix matrix, ProjectionData pdata, ProjectionView view) {
        try {
            int i;
            if (view != null) {
                view.setStatus("Finding the nearest neighbors...", 40);
            }
            Dissimilarity diss = DissimilarityFactory.getInstance(pdata.getDissimilarityType());
            KNN knn = new KNN(pdata.getNumberNeighborsConnection());
            Pair[][] neighbors = knn.execute(matrix, diss);
            if (view != null) {
                view.setStatus("Constructing the weights...", 50);
            }
            SparseDoubleMatrix2D w = new SparseDoubleMatrix2D(matrix.getRowCount(), matrix.getRowCount());
            for (int i2 = 0; i2 < matrix.getRowCount(); ++i2) {
                int j;
                float[][] z_aux = new float[neighbors[i2].length][];
                float[] x = matrix.getRow(i2).toArray();
                for (int j2 = 0; j2 < neighbors[i2].length; ++j2) {
                    z_aux[j2] = matrix.getRow(neighbors[i2][j2].index).toArray();
                    for (int n = 0; n < z_aux[j2].length; ++n) {
                        z_aux[j2][n] = z_aux[j2][n] - x[n];
                    }
                }
                SparseDoubleMatrix2D z = new SparseDoubleMatrix2D(z_aux.length, matrix.getDimensions());
                for (int j3 = 0; j3 < z_aux.length; ++j3) {
                    for (int n = 0; n < z_aux[j3].length; ++n) {
                        z.setQuick(j3, n, (double)z_aux[j3][n]);
                    }
                }
                DoubleMatrix2D c = z.zMult((DoubleMatrix2D)z, null, 1.0, 1.0, false, true);
                Algebra alg1 = new Algebra();
                double eps = 0.001 * alg1.trace(c);
                for (int j4 = 0; j4 < z_aux.length; ++j4) {
                    c.setQuick(j4, j4, c.getQuick(j4, j4) + eps);
                }
                DenseDoubleMatrix2D b = new DenseDoubleMatrix2D(z_aux.length, 1);
                for (int j5 = 0; j5 < z_aux.length; ++j5) {
                    b.setQuick(j5, 0, 1.0);
                }
                Algebra alg2 = new Algebra();
                DoubleMatrix2D result = alg2.solve(c, (DoubleMatrix2D)b);
                double sum = 0.0;
                for (j = 0; j < result.rows(); ++j) {
                    sum += result.getQuick(j, 0);
                }
                w.setQuick(i2, i2, 1.0);
                for (j = 0; j < result.rows(); ++j) {
                    double value = result.getQuick(j, 0) / sum;
                    w.setQuick(i2, neighbors[i2][j].index, -value);
                }
            }
            DoubleMatrix2D m = w.zMult((DoubleMatrix2D)w, null, 1.0, 1.0, true, false);
            if (view != null) {
                view.setStatus("Calculating the eigenvectors...", 70);
            }
            EigenvalueDecomposition dec = new EigenvalueDecomposition(m);
            DoubleMatrix2D eigenvectors = dec.getV();
            DoubleMatrix1D eigenvalues = dec.getRealEigenvalues();
            if (view != null) {
                view.setStatus("Assembling the final projection...", 90);
            }
            float[][] projection = new float[matrix.getRowCount()][];
            for (i = 0; i < projection.length; ++i) {
                projection[i] = new float[2];
            }
            int j = 0;
            for (i = 1; i < eigenvalues.size() && j < 2; ++i) {
                if (!(eigenvalues.get(i) > (double)1.4E-45f)) continue;
                for (int n = 0; n < projection.length; ++n) {
                    projection[n][j] = (float)eigenvectors.getQuick(n, i);
                }
                ++j;
            }
            return projection;
        }
        catch (IOException ex) {
            Logger.getLogger(LLEProjection.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public float[][] project(DistanceMatrix dmat, ProjectionData pdata, ProjectionView view) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ProjectionView getProjectionView(ProjectionData pdata) {
        return new LLEProjectionView(pdata);
    }

    public static void main(String[] args) {
        try {
            String filename = "D:\\My Documents\\FERNANDO\\Tese\\cbrilpirson.data";
            Matrix matrix = MatrixFactory.getInstance(filename);
            for (int i = 3; i <= 25; ++i) {
                BufferedWriter out = null;
                try {
                    out = new BufferedWriter(new FileWriter(filename + "_" + i + ".prj"));
                    ProjectionData pdata = new ProjectionData();
                    pdata.setDissimilarityType(DissimilarityType.COSINE_BASED);
                    pdata.setNumberNeighborsConnection(i);
                    LLEProjection lle = new LLEProjection();
                    float[][] projection = lle.project(matrix, pdata, null);
                    out.write("DY\r\n");
                    out.write(Integer.toString(projection.length) + "\r\n");
                    out.write("2\r\n");
                    out.write("x;y\r\n");
                    for (int j = 0; j < projection.length; ++j) {
                        out.write(matrix.getRow(j).getId());
                        out.write(";");
                        out.write(Float.toString(projection[j][0]));
                        out.write(";");
                        out.write(Float.toString(projection[j][1]));
                        out.write(";");
                        out.write(Float.toString(matrix.getRow(j).getKlass()));
                        out.write("\r\n");
                    }
                    continue;
                }
                catch (IOException e) {
                    throw new IOException(e.getMessage());
                }
                finally {
                    if (out != null) {
                        try {
                            out.flush();
                            out.close();
                        }
                        catch (IOException ex) {
                            Logger.getLogger(LLEProjection.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(LLEProjection.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

