/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection.lsp;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.linalg.CholeskyDecomposition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import lspsolver.Solver;
import visualizer.datamining.clustering.BKmeans;
import visualizer.datamining.clustering.Kmedoids;
import visualizer.graph.Graph;
import visualizer.graph.Scalar;
import visualizer.matrix.Matrix;
import visualizer.matrix.MatrixFactory;
import visualizer.projection.ForceScheme;
import visualizer.projection.Projection;
import visualizer.projection.ProjectionData;
import visualizer.projection.Projector;
import visualizer.projection.ProjectorFactory;
import visualizer.projection.distance.Dissimilarity;
import visualizer.projection.distance.DissimilarityFactory;
import visualizer.projection.distance.DistanceMatrix;
import visualizer.projection.idmap.IDMAPProjection;
import visualizer.projection.lsp.ControlPointsType;
import visualizer.projection.lsp.LSPProjectionView;
import visualizer.projection.lsp.MeshGenerator;
import visualizer.util.ApproxKNN;
import visualizer.util.KNN;
import visualizer.util.Pair;
import visualizer.wizard.ProjectionView;

public class LSPProjection2D
extends Projection {
    private float[][] projection_cp;
    private int[] controlPoints;
    private Dissimilarity diss;

    @Override
    public float[][] project(Matrix matrix, ProjectionData pdata, ProjectionView view) {
        float[][] projection = null;
        ArrayList<ArrayList<Integer>> clusters = null;
        Matrix centroids = null;
        try {
            BKmeans bkmeans;
            this.diss = DissimilarityFactory.getInstance(pdata.getDissimilarityType());
            if (pdata.getControlPointsChoice() == ControlPointsType.KMEANS) {
                int i;
                if (view != null) {
                    view.setStatus("Calculating the B-KMEANS...", 40);
                }
                bkmeans = new BKmeans(pdata.getNumberControlPoints());
                clusters = bkmeans.execute(this.diss, matrix);
                centroids = bkmeans.getCentroids();
                this.controlPoints = bkmeans.getMedoids(matrix);
                ArrayList<Integer> medoids_aux = new ArrayList<Integer>();
                for (i = 0; i < this.controlPoints.length; ++i) {
                    medoids_aux.add(this.controlPoints[i]);
                }
                while (medoids_aux.size() < pdata.getNumberControlPoints()) {
                    block4: for (int c = 0; c < clusters.size() && medoids_aux.size() < pdata.getNumberControlPoints(); ++c) {
                        if (clusters.get(c).size() <= matrix.getRowCount() / pdata.getNumberControlPoints()) continue;
                        for (int i2 = 0; i2 < clusters.get(c).size(); ++i2) {
                            if (medoids_aux.contains(clusters.get(c).get(i2))) continue;
                            medoids_aux.add(clusters.get(c).get(i2));
                            continue block4;
                        }
                    }
                }
                this.controlPoints = new int[medoids_aux.size()];
                for (i = 0; i < this.controlPoints.length; ++i) {
                    this.controlPoints[i] = (Integer)medoids_aux.get(i);
                }
                pdata.setNumberControlPoints(this.controlPoints.length);
            } else if (pdata.getControlPointsChoice() == ControlPointsType.RANDOM) {
                this.controlPoints = new int[pdata.getNumberControlPoints()];
                for (int i = 0; i < this.controlPoints.length; ++i) {
                    this.controlPoints[i] = (int)(Math.random() * (double)matrix.getRowCount());
                }
                bkmeans = new BKmeans(pdata.getNumberControlPoints());
                clusters = bkmeans.execute(this.diss, matrix);
                centroids = bkmeans.getCentroids();
            }
            if (view != null) {
                view.setStatus("Calculating the nearest neigbbors...", 35);
            }
            int max = Math.max(pdata.getKnnNumberNeighbors(), pdata.getNumberNeighborsConnection());
            int min = Math.min(pdata.getKnnNumberNeighbors(), pdata.getNumberNeighborsConnection());
            ApproxKNN appknn = new ApproxKNN(max);
            Pair[][] maxneighbors = appknn.execute(matrix, this.diss, clusters, centroids);
            Pair[][] minneighbors = new Pair[maxneighbors.length][];
            for (int i = 0; i < minneighbors.length; ++i) {
                minneighbors[i] = new Pair[min];
                for (int j = 0; j < min; ++j) {
                    minneighbors[i][j] = maxneighbors[i][j];
                }
            }
            Pair[][] mesh = null;
            if (pdata.getKnnNumberNeighbors() > pdata.getNumberNeighborsConnection()) {
                this.knnneighbors = maxneighbors;
                mesh = minneighbors;
            } else {
                this.knnneighbors = minneighbors;
                mesh = maxneighbors;
            }
            Matrix matrix_cp = MatrixFactory.getInstance(matrix.getClass());
            for (int i = 0; i < this.controlPoints.length; ++i) {
                matrix_cp.addRow(matrix.getRow(this.controlPoints[i]));
            }
            DistanceMatrix dmat_cp = new DistanceMatrix(matrix_cp, this.diss);
            if (view != null) {
                view.setStatus("Projecting...", 40);
            }
            IDMAPProjection idmap = new IDMAPProjection();
            this.projection_cp = idmap.project(dmat_cp, pdata, view);
            if (view != null) {
                view.setStatus("Creating the mesh...", 45);
            }
            MeshGenerator meshgen = new MeshGenerator();
            mesh = meshgen.execute(mesh, matrix, this.diss);
            if (view != null) {
                view.setStatus("Solving the system...", 65);
            }
            projection = this.createFinalProjection(mesh, matrix, pdata);
        }
        catch (IOException ex) {
            Logger.getLogger(LSPProjection2D.class.getName()).log(Level.SEVERE, null, ex);
        }
        return projection;
    }

    @Override
    public float[][] project(DistanceMatrix dmat, ProjectionData pdata, ProjectionView view) {
        try {
            this.dmat = dmat;
            KNN knn = new KNN(pdata.getKnnNumberNeighbors());
            this.knnneighbors = knn.execute(dmat);
            if (pdata.getControlPointsChoice() == ControlPointsType.KMEDOIDS) {
                if (view != null) {
                    view.setStatus("Calculating the KMEDOIDS...", 40);
                }
                Kmedoids kmedois = new Kmedoids(pdata.getNumberControlPoints());
                kmedois.execute(dmat);
                this.controlPoints = kmedois.getMedoids();
            } else if (pdata.getControlPointsChoice() == ControlPointsType.RANDOM) {
                this.controlPoints = new int[pdata.getNumberControlPoints()];
                for (int i = 0; i < this.controlPoints.length; ++i) {
                    this.controlPoints[i] = (int)(Math.random() * (double)dmat.getElementCount());
                }
            }
            DistanceMatrix dmat_cp = new DistanceMatrix(pdata.getNumberControlPoints());
            for (int i = 0; i < pdata.getNumberControlPoints(); ++i) {
                for (int j = 0; j < pdata.getNumberControlPoints(); ++j) {
                    if (i == j) continue;
                    dmat_cp.setDistance(i, j, dmat.getDistance(this.controlPoints[i], this.controlPoints[j]));
                }
            }
            if (view != null) {
                view.setStatus("Projecting...", 40);
            }
            Projector proj = ProjectorFactory.getInstance(pdata.getProjectorType());
            this.projection_cp = proj.project(dmat_cp);
            if (this.projection_cp != null) {
                ForceScheme force = new ForceScheme(pdata.getFractionDelta(), this.projection_cp.length);
                for (int i = 0; i < pdata.getNumberIterations(); ++i) {
                    if (view != null) {
                        view.setStatus("Improving the projection...", (int)(45.0f + (float)i * 50.0f / (float)pdata.getNumberIterations()));
                    }
                    force.iteration(dmat_cp, this.projection_cp);
                }
            }
            if (view != null) {
                view.setStatus("Creating the mesh...", 45);
            }
            KNN knnmesh = new KNN(pdata.getNumberNeighborsConnection());
            Pair[][] mesh = knnmesh.execute(dmat);
            MeshGenerator meshgen = new MeshGenerator();
            mesh = meshgen.execute(mesh, dmat);
            if (view != null) {
                view.setStatus("Solving the system...", 50);
            }
            return this.createFinalProjection(mesh, dmat, pdata);
        }
        catch (IOException ex) {
            Logger.getLogger(LSPProjection2D.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public ProjectionView getProjectionView(ProjectionData pdata) {
        return new LSPProjectionView(pdata);
    }

    @Override
    public void postProcessing(Graph graph) {
        int i;
        Scalar s = graph.addScalar("pivots");
        for (i = 0; i < graph.getVertex().size(); ++i) {
            graph.getVertex().get(i).setScalar(s, 0.0f);
        }
        for (i = 0; i < this.controlPoints.length; ++i) {
            graph.getVertex().get(this.controlPoints[i]).setScalar(s, 1.0f);
        }
    }

    private float[][] createFinalProjection(Pair[][] neighbors, Matrix matrix, ProjectionData pdata) throws IOException {
        float[][] projection = new float[matrix.getRowCount()][];
        if (System.getProperty("os.name").toLowerCase().equals("windows xp") || System.getProperty("os.name").toLowerCase().equals("windows vista") || System.getProperty("os.name").toLowerCase().indexOf("linux") > -1) {
            this.projectUsingProgram(pdata, neighbors, projection);
        } else {
            this.projectUsingColt(pdata, neighbors, projection);
        }
        Runtime.getRuntime().gc();
        return projection;
    }

    private float[][] createFinalProjection(Pair[][] neighbors, DistanceMatrix dmat, ProjectionData pdata) {
        float[][] projection = new float[dmat.getElementCount()][];
        if (System.getProperty("os.name").toLowerCase().equals("windows xp") || System.getProperty("os.name").toLowerCase().equals("windows vista") || System.getProperty("os.name").toLowerCase().indexOf("linux") > -1) {
            this.projectUsingProgram(pdata, neighbors, projection);
        } else {
            this.projectUsingColt(pdata, neighbors, projection);
        }
        Runtime.getRuntime().gc();
        return projection;
    }

    private void projectUsingColt(ProjectionData pdata, Pair[][] neighbors, float[][] projection) {
        int i;
        long start = System.currentTimeMillis();
        int nRows = neighbors.length + pdata.getNumberControlPoints();
        int nColumns = neighbors.length;
        SparseDoubleMatrix2D A = new SparseDoubleMatrix2D(nRows, nColumns);
        for (i = 0; i < neighbors.length; ++i) {
            A.setQuick(i, i, 1.0);
            for (int j = 0; j < neighbors[i].length; ++j) {
                A.setQuick(i, neighbors[i][j].index, (double)(-(1.0f / (float)neighbors[i].length)));
            }
        }
        for (i = 0; i < pdata.getNumberControlPoints(); ++i) {
            A.setQuick(projection.length + i, this.controlPoints[i], 1.0);
        }
        SparseDoubleMatrix2D B = new SparseDoubleMatrix2D(nRows, 2);
        for (int i2 = 0; i2 < this.projection_cp.length; ++i2) {
            B.setQuick(neighbors.length + i2, 0, (double)this.projection_cp[i2][0]);
            B.setQuick(neighbors.length + i2, 1, (double)this.projection_cp[i2][1]);
        }
        DoubleMatrix2D AtA = A.zMult((DoubleMatrix2D)A, null, 1.0, 1.0, true, false);
        DoubleMatrix2D AtB = A.zMult((DoubleMatrix2D)B, null, 1.0, 1.0, true, false);
        start = System.currentTimeMillis();
        CholeskyDecomposition chol = new CholeskyDecomposition(AtA);
        DoubleMatrix2D X = chol.solve(AtB);
        for (int i3 = 0; i3 < X.rows(); ++i3) {
            projection[i3] = new float[2];
            projection[i3][0] = (float)X.getQuick(i3, 0);
            projection[i3][1] = (float)X.getQuick(i3, 1);
        }
        long finish = System.currentTimeMillis();
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Solving the system using Colt time: " + (float)(finish - start) / 1000.0f + "s");
    }

    private void projectUsingProgram(ProjectionData pdata, Pair[][] neighbors, float[][] projection) {
        long start = System.currentTimeMillis();
        int nRows = neighbors.length + pdata.getNumberControlPoints();
        int nColumns = neighbors.length;
        Solver solver = new Solver(nRows, nColumns);
        try {
            int i;
            for (i = 0; i < neighbors.length; ++i) {
                solver.addToA(i, i, 1.0f);
                for (int j = 0; j < neighbors[i].length; ++j) {
                    solver.addToA(i, neighbors[i][j].index, -(1.0f / (float)neighbors[i].length));
                }
            }
            for (i = 0; i < pdata.getNumberControlPoints(); ++i) {
                solver.addToA(projection.length + i, this.controlPoints[i], 1.0f);
            }
            for (i = 0; i < this.projection_cp.length; ++i) {
                solver.addToB(neighbors.length + i, 0, this.projection_cp[i][0]);
                solver.addToB(neighbors.length + i, 1, this.projection_cp[i][1]);
            }
            float[] result = solver.solve();
            for (int i2 = 0; i2 < result.length; i2 += 2) {
                projection[i2 / 2] = new float[2];
                projection[i2 / 2][0] = result[i2];
                projection[i2 / 2][1] = result[i2 + 1];
            }
        }
        catch (IOException ex) {
            Logger.getLogger(LSPProjection2D.class.getName()).log(Level.SEVERE, null, ex);
        }
        long finish = System.currentTimeMillis();
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Solving the system using LSPSolver time: " + (float)(finish - start) / 1000.0f + "s");
    }
}

