/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection.lsp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import visualizer.projection.ProjectionData;
import visualizer.projection.ProjectorType;
import visualizer.projection.SourceType;
import visualizer.projection.distance.DissimilarityType;
import visualizer.projection.lsp.ControlPointsType;
import visualizer.util.Util;
import visualizer.wizard.ProjectionView;

public class LSPProjectionView
extends ProjectionView {
    private JPanel controlPointsChoicePanel;
    private ButtonGroup controlPointsChoiseButtonGroup;
    private JLabel deltaLabel;
    private JTextField deltaTextField;
    private JRadioButton fastmapRadioButton;
    private JPanel improvementPanel;
    private JRadioButton kmeansRadioButton;
    private JRadioButton kmedoidsRadioButton;
    private JPanel lspPanel;
    private JLabel nIterationsLabel;
    private JTextField nIterationsTextField;
    private JRadioButton nnpRadioButton;
    private JLabel numberCPLabel;
    private JTextField numberCPTextField;
    private JLabel numberNeighborsLabel;
    private JTextField numberNeighborsTextField;
    private ButtonGroup projectionButtonGroup;
    private JPanel projectionPanel;
    private JRadioButton randomRadioButton;
    private JLabel statusLabel;
    private JPanel statusPanel;
    private JProgressBar statusProgressBar;

    public LSPProjectionView(ProjectionData pdata) {
        super(pdata);
        this.initComponents();
    }

    private void initComponents() {
        this.projectionButtonGroup = new ButtonGroup();
        this.controlPointsChoiseButtonGroup = new ButtonGroup();
        this.projectionPanel = new JPanel();
        this.nnpRadioButton = new JRadioButton();
        this.fastmapRadioButton = new JRadioButton();
        this.improvementPanel = new JPanel();
        this.nIterationsLabel = new JLabel();
        this.deltaLabel = new JLabel();
        this.deltaTextField = new JTextField();
        this.nIterationsTextField = new JTextField();
        this.statusPanel = new JPanel();
        this.statusProgressBar = new JProgressBar();
        this.statusLabel = new JLabel();
        this.lspPanel = new JPanel();
        this.numberCPLabel = new JLabel();
        this.numberNeighborsLabel = new JLabel();
        this.numberCPTextField = new JTextField();
        this.numberNeighborsTextField = new JTextField();
        this.controlPointsChoicePanel = new JPanel();
        this.kmedoidsRadioButton = new JRadioButton();
        this.randomRadioButton = new JRadioButton();
        this.kmeansRadioButton = new JRadioButton();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder("LSP Projection"));
        this.projectionPanel.setLayout(new GridBagLayout());
        this.projectionPanel.setBorder(BorderFactory.createTitledBorder("Type of Projection"));
        this.projectionButtonGroup.add(this.nnpRadioButton);
        this.nnpRadioButton.setText("Nearest Neighbor Projection");
        this.nnpRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.nnpRadioButton.setMargin(new Insets(0, 0, 0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.projectionPanel.add((Component)this.nnpRadioButton, gridBagConstraints);
        this.projectionButtonGroup.add(this.fastmapRadioButton);
        this.fastmapRadioButton.setSelected(true);
        this.fastmapRadioButton.setText("Fastmap Projection");
        this.fastmapRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.fastmapRadioButton.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.projectionPanel.add((Component)this.fastmapRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.projectionPanel, gridBagConstraints);
        this.improvementPanel.setLayout(new GridBagLayout());
        this.improvementPanel.setBorder(BorderFactory.createTitledBorder("Projection Improvement (Force)"));
        this.nIterationsLabel.setText("Number of iterations");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.improvementPanel.add((Component)this.nIterationsLabel, gridBagConstraints);
        this.deltaLabel.setText("Fraction of delta");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.improvementPanel.add((Component)this.deltaLabel, gridBagConstraints);
        this.deltaTextField.setColumns(5);
        this.deltaTextField.setText("8.0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.improvementPanel.add((Component)this.deltaTextField, gridBagConstraints);
        this.nIterationsTextField.setColumns(5);
        this.nIterationsTextField.setText("50");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.improvementPanel.add((Component)this.nIterationsTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.improvementPanel, gridBagConstraints);
        this.statusPanel.setLayout(new BorderLayout());
        this.statusPanel.setBorder(BorderFactory.createTitledBorder("Status"));
        this.statusProgressBar.setPreferredSize(new Dimension(150, 22));
        this.statusProgressBar.setStringPainted(true);
        this.statusPanel.add((Component)this.statusProgressBar, "South");
        this.statusLabel.setText("   ");
        this.statusLabel.setMinimumSize(new Dimension(100, 22));
        this.statusLabel.setPreferredSize(new Dimension(100, 22));
        this.statusPanel.add((Component)this.statusLabel, "North");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.statusPanel, gridBagConstraints);
        this.lspPanel.setLayout(new GridBagLayout());
        this.lspPanel.setBorder(BorderFactory.createTitledBorder("LSP parameters"));
        this.numberCPLabel.setText("Number Control Points");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.lspPanel.add((Component)this.numberCPLabel, gridBagConstraints);
        this.numberNeighborsLabel.setText("Number of Neighbors");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.lspPanel.add((Component)this.numberNeighborsLabel, gridBagConstraints);
        this.numberCPTextField.setColumns(5);
        this.numberCPTextField.setText("10");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.lspPanel.add((Component)this.numberCPTextField, gridBagConstraints);
        this.numberNeighborsTextField.setColumns(5);
        this.numberNeighborsTextField.setText("10");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.lspPanel.add((Component)this.numberNeighborsTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)this.lspPanel, gridBagConstraints);
        this.controlPointsChoicePanel.setLayout(new GridBagLayout());
        this.controlPointsChoicePanel.setBorder(BorderFactory.createTitledBorder("Control Points Choice"));
        this.controlPointsChoiseButtonGroup.add(this.kmedoidsRadioButton);
        this.kmedoidsRadioButton.setSelected(true);
        this.kmedoidsRadioButton.setText("K-medoids");
        this.kmedoidsRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.kmedoidsRadioButton.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.controlPointsChoicePanel.add((Component)this.kmedoidsRadioButton, gridBagConstraints);
        this.controlPointsChoiseButtonGroup.add(this.randomRadioButton);
        this.randomRadioButton.setText("Random");
        this.randomRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.randomRadioButton.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.controlPointsChoicePanel.add((Component)this.randomRadioButton, gridBagConstraints);
        this.controlPointsChoiseButtonGroup.add(this.kmeansRadioButton);
        this.kmeansRadioButton.setText("K-means");
        this.kmeansRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.kmeansRadioButton.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.controlPointsChoicePanel.add((Component)this.kmeansRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)this.controlPointsChoicePanel, gridBagConstraints);
    }

    @Override
    public void setStatus(String status, int value) {
        this.statusLabel.setText(status);
        this.statusProgressBar.setValue(value);
    }

    @Override
    public void reset() {
        if (this.pdata.getSourceType() == SourceType.DISTANCE_MATRIX || this.pdata.getDissimilarityType() == DissimilarityType.KOLMOGOROV) {
            this.kmeansRadioButton.setEnabled(false);
            this.kmedoidsRadioButton.setEnabled(true);
            if (this.kmeansRadioButton.isSelected()) {
                this.kmeansRadioButton.setSelected(false);
                this.kmedoidsRadioButton.setSelected(true);
            }
        } else {
            this.kmeansRadioButton.setEnabled(true);
            this.kmedoidsRadioButton.setEnabled(false);
            if (this.kmedoidsRadioButton.isSelected()) {
                this.kmeansRadioButton.setSelected(true);
                this.kmedoidsRadioButton.setSelected(false);
            }
        }
        int nrobjects = 0;
        if (this.pdata.getSourceType() == SourceType.CORPUS) {
            nrobjects = Util.countFiles(this.pdata.getSourceFile());
        } else if (this.pdata.getSourceType() == SourceType.DISTANCE_MATRIX) {
            try {
                nrobjects = Util.countObjectsDistanceFile(this.pdata.getSourceFile());
            }
            catch (IOException ex) {
                Logger.getLogger(LSPProjectionView.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (this.pdata.getSourceType() == SourceType.POINTS) {
            try {
                nrobjects = Util.countObjectsPointsFile(this.pdata.getSourceFile());
            }
            catch (IOException ex) {
                Logger.getLogger(LSPProjectionView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.numberCPTextField.setText(Integer.toString(nrobjects / 10));
        if (nrobjects < 100) {
            this.numberCPTextField.setText("10");
        } else if (nrobjects > 1500) {
            this.numberNeighborsTextField.setText("15");
        } else {
            this.numberNeighborsTextField.setText("10");
        }
    }

    @Override
    public void refreshData() {
        this.pdata.setFractionDelta(Float.parseFloat(this.deltaTextField.getText()));
        this.pdata.setNumberIterations(Integer.parseInt(this.nIterationsTextField.getText()));
        this.pdata.setNumberControlPoints(Integer.parseInt(this.numberCPTextField.getText()));
        this.pdata.setNumberNeighborsConnection(Integer.parseInt(this.numberNeighborsTextField.getText()));
        if (this.fastmapRadioButton.isSelected()) {
            this.pdata.setProjectorType(ProjectorType.FASTMAP);
        } else {
            this.pdata.setProjectorType(ProjectorType.NNP);
        }
        if (this.kmedoidsRadioButton.isSelected()) {
            this.pdata.setControlPointsChoice(ControlPointsType.KMEDOIDS);
        } else if (this.kmeansRadioButton.isSelected()) {
            this.pdata.setControlPointsChoice(ControlPointsType.KMEANS);
        } else {
            this.pdata.setControlPointsChoice(ControlPointsType.RANDOM);
        }
    }
}

