/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection.mds;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.EigenvalueDecomposition;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import visualizer.matrix.Matrix;
import visualizer.matrix.MatrixFactory;
import visualizer.projection.Projection;
import visualizer.projection.ProjectionData;
import visualizer.projection.distance.Dissimilarity;
import visualizer.projection.distance.DissimilarityFactory;
import visualizer.projection.distance.DissimilarityType;
import visualizer.projection.distance.DistanceMatrix;
import visualizer.projection.idmap.IDMAPProjection;
import visualizer.projection.lle.LLEProjection;
import visualizer.projection.mds.ClassicalScalingProjectionView;
import visualizer.wizard.ProjectionView;

public class ClassicalScalingProjection
extends Projection {
    private static final float EPSILON = Float.MIN_VALUE;

    @Override
    public float[][] project(Matrix matrix, ProjectionData pdata, ProjectionView view) {
        try {
            if (view != null) {
                view.setStatus("Calculating the dissimilarities...", 40);
            }
            Dissimilarity diss = DissimilarityFactory.getInstance(pdata.getDissimilarityType());
            DistanceMatrix dmat_aux = new DistanceMatrix(matrix, diss);
            dmat_aux.setIds(matrix.getIds());
            dmat_aux.setClassData(matrix.getClassData());
            float[][] projection = this.project(dmat_aux, pdata, view);
            return projection;
        }
        catch (IOException ex) {
            Logger.getLogger(IDMAPProjection.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public float[][] project(DistanceMatrix dmat, ProjectionData pdata, ProjectionView view) {
        this.dmat = dmat;
        DenseDoubleMatrix2D D = new DenseDoubleMatrix2D(dmat.getElementCount(), dmat.getElementCount());
        for (int i = 0; i < dmat.getElementCount() - 1; ++i) {
            for (int k = i + 1; k < dmat.getElementCount(); ++k) {
                D.setQuick(i, k, (double)(dmat.getDistance(i, k) * dmat.getDistance(i, k)));
                D.setQuick(k, i, (double)(dmat.getDistance(i, k) * dmat.getDistance(i, k)));
            }
        }
        if (view != null) {
            view.setStatus("Applying the double centering...", 50);
        }
        DoubleMatrix2D J = DoubleFactory2D.dense.identity(dmat.getElementCount());
        double value = 1.0 / (double)dmat.getElementCount();
        for (int i = 0; i < dmat.getElementCount(); ++i) {
            for (int k = 0; k < dmat.getElementCount(); ++k) {
                J.setQuick(i, k, J.getQuick(i, k) - value);
            }
        }
        DoubleMatrix2D b = J.zMult((DoubleMatrix2D)D, null, -0.5, 1.0, false, false).zMult(J, null, 1.0, 1.0, false, false);
        if (view != null) {
            view.setStatus("Calculating the eigenvectors...", 70);
        }
        EigenvalueDecomposition dec = new EigenvalueDecomposition(b);
        DoubleMatrix2D eigenvectors = dec.getV();
        DoubleMatrix1D eigenvalues = dec.getRealEigenvalues();
        if (view != null) {
            view.setStatus("Assembling the final projection...", 90);
        }
        DenseDoubleMatrix2D Q = new DenseDoubleMatrix2D(dmat.getElementCount(), 2);
        DenseDoubleMatrix2D A = new DenseDoubleMatrix2D(2, 2);
        int k = 0;
        for (int i = eigenvalues.size() - 1; i >= 0 && k < 2; --i) {
            if (!(eigenvalues.get(i) > (double)1.4E-45f)) continue;
            for (int n = 0; n < Q.rows(); ++n) {
                Q.setQuick(n, k, eigenvectors.getQuick(n, i));
            }
            A.setQuick(k, k, Math.sqrt(eigenvalues.getQuick(i)));
            ++k;
        }
        DoubleMatrix2D result = Q.zMult((DoubleMatrix2D)A, null, 1.0, 1.0, false, false);
        float[][] projection = new float[result.rows()][];
        for (int i = 0; i < projection.length; ++i) {
            projection[i] = new float[2];
            projection[i][0] = (float)result.getQuick(i, 0);
            projection[i][1] = (float)result.getQuick(i, 1);
        }
        return projection;
    }

    @Override
    public ProjectionView getProjectionView(ProjectionData pdata) {
        return new ClassicalScalingProjectionView(pdata);
    }

    public static void main(String[] args) {
        try {
            String filename = "G:\\User\\users\\Documents\\FERNANDO\\Tese\\datasets\\iris-std.data";
            Matrix matrix = MatrixFactory.getInstance(filename);
            BufferedWriter out = null;
            try {
                out = new BufferedWriter(new FileWriter(filename + ".prj"));
                ProjectionData pdata = new ProjectionData();
                pdata.setDissimilarityType(DissimilarityType.EUCLIDEAN);
                ClassicalScalingProjection csp = new ClassicalScalingProjection();
                float[][] projection = csp.project(matrix, pdata, null);
                out.write("x;y\r\n");
                for (int j = 0; j < projection.length; ++j) {
                    out.write(matrix.getRow(j).getId());
                    out.write(";");
                    out.write(Float.toString(projection[j][0]));
                    out.write(";");
                    out.write(Float.toString(projection[j][1]));
                    out.write(";");
                    out.write(Float.toString(matrix.getRow(j).getKlass()));
                    out.write("\r\n");
                }
            }
            catch (IOException e) {
                throw new IOException(e.getMessage());
            }
            finally {
                if (out != null) {
                    try {
                        out.flush();
                        out.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(LLEProjection.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(LLEProjection.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

