/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection.projclus;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import visualizer.projection.ProjectionData;
import visualizer.projection.ProjectorType;
import visualizer.wizard.ProjectionView;

public class ProjClusProjectionView
extends ProjectionView {
    private static final long serialVersionUID = 1L;
    private JLabel clusterFactorLabel;
    private JTextField clusterFactorTextField;
    private JLabel deltaLabel;
    private JTextField deltaTextField;
    private JRadioButton fastmapRadioButton;
    private JPanel improvementPanel;
    private JLabel nIterationsLabel;
    private JTextField nIterationsTextField;
    private JRadioButton nnpRadioButton;
    private ButtonGroup projectionButtonGroup;
    private JPanel projectionPanel;
    private JLabel statusLabel;
    private JPanel statusPanel;
    private JProgressBar statusProgressBar;

    public ProjClusProjectionView(ProjectionData pdata) {
        super(pdata);
        this.initComponents();
    }

    private void initComponents() {
        this.projectionButtonGroup = new ButtonGroup();
        this.improvementPanel = new JPanel();
        this.nIterationsLabel = new JLabel();
        this.deltaLabel = new JLabel();
        this.deltaTextField = new JTextField();
        this.nIterationsTextField = new JTextField();
        this.clusterFactorLabel = new JLabel();
        this.clusterFactorTextField = new JTextField();
        this.statusPanel = new JPanel();
        this.statusProgressBar = new JProgressBar();
        this.statusLabel = new JLabel();
        this.projectionPanel = new JPanel();
        this.nnpRadioButton = new JRadioButton();
        this.fastmapRadioButton = new JRadioButton();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder("ProjClus Projection"));
        this.improvementPanel.setLayout(new GridBagLayout());
        this.improvementPanel.setBorder(BorderFactory.createTitledBorder("Projection Improvement (Force)"));
        this.nIterationsLabel.setText("Number of iterations");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.improvementPanel.add((Component)this.nIterationsLabel, gridBagConstraints);
        this.deltaLabel.setText("Fraction of delta");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.improvementPanel.add((Component)this.deltaLabel, gridBagConstraints);
        this.deltaTextField.setColumns(5);
        this.deltaTextField.setText("8.0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.improvementPanel.add((Component)this.deltaTextField, gridBagConstraints);
        this.nIterationsTextField.setColumns(5);
        this.nIterationsTextField.setText("50");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.improvementPanel.add((Component)this.nIterationsTextField, gridBagConstraints);
        this.clusterFactorLabel.setText("Cluster Factor");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.improvementPanel.add((Component)this.clusterFactorLabel, gridBagConstraints);
        this.clusterFactorTextField.setColumns(5);
        this.clusterFactorTextField.setText("4.5");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.improvementPanel.add((Component)this.clusterFactorTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.improvementPanel, gridBagConstraints);
        this.statusPanel.setLayout(new BorderLayout());
        this.statusPanel.setBorder(BorderFactory.createTitledBorder("Status"));
        this.statusProgressBar.setPreferredSize(new Dimension(150, 22));
        this.statusProgressBar.setStringPainted(true);
        this.statusPanel.add((Component)this.statusProgressBar, "South");
        this.statusLabel.setText("   ");
        this.statusLabel.setMinimumSize(new Dimension(100, 22));
        this.statusLabel.setPreferredSize(new Dimension(100, 22));
        this.statusPanel.add((Component)this.statusLabel, "North");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.statusPanel, gridBagConstraints);
        this.projectionPanel.setLayout(new GridBagLayout());
        this.projectionPanel.setBorder(BorderFactory.createTitledBorder("Type of Projection"));
        this.projectionButtonGroup.add(this.nnpRadioButton);
        this.nnpRadioButton.setText("Nearest Neighbor Projection");
        this.nnpRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.nnpRadioButton.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.projectionPanel.add((Component)this.nnpRadioButton, gridBagConstraints);
        this.projectionButtonGroup.add(this.fastmapRadioButton);
        this.fastmapRadioButton.setSelected(true);
        this.fastmapRadioButton.setText("Fastmap Projection");
        this.fastmapRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.fastmapRadioButton.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.projectionPanel.add((Component)this.fastmapRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.projectionPanel, gridBagConstraints);
    }

    @Override
    public void setStatus(String status, int value) {
        this.statusLabel.setText(status);
        this.statusProgressBar.setValue(value);
    }

    @Override
    public void refreshData() {
        this.pdata.setFractionDelta(Float.parseFloat(this.deltaTextField.getText()));
        this.pdata.setNumberIterations(Integer.parseInt(this.nIterationsTextField.getText()));
        this.pdata.setClusterFactor(Float.parseFloat(this.clusterFactorTextField.getText()));
        if (this.fastmapRadioButton.isSelected()) {
            this.pdata.setProjectorType(ProjectorType.FASTMAP);
        } else {
            this.pdata.setProjectorType(ProjectorType.NNP);
        }
    }
}

