/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection.sammon;

import java.io.IOException;
import visualizer.matrix.Matrix;
import visualizer.projection.distance.DistanceMatrix;

public class SammonMapping {
    private static final float EPSILON = 1.0E-6f;
    private float MF = 0.3f;

    public float getMF() {
        return this.MF;
    }

    public void setMF(float MF) {
        this.MF = MF;
    }

    public float[][] createInitialProjection(Matrix matrix) throws IOException {
        int j;
        float[][] points = matrix.toMatrix();
        float[][] projection = new float[points.length][];
        for (int i = 0; i < projection.length; ++i) {
            projection[i] = new float[2];
        }
        int dimensions = points[0].length;
        float[] mins = new float[dimensions];
        float[] maxs = new float[dimensions];
        float[] normalized_averages = new float[dimensions];
        float[] normalized_variances = new float[dimensions];
        float[] averages = new float[dimensions];
        float[] variances = new float[dimensions];
        for (int i = 0; i < dimensions; ++i) {
            mins[i] = points[0][i];
            maxs[i] = points[0][i];
            averages[i] = points[0][i];
            variances[i] = 0.0f;
            normalized_variances[i] = 0.0f;
        }
        float t = 0.0f;
        for (int i = 1; i < projection.length; ++i) {
            if (dimensions != points[i].length) {
                throw new IOException("Corrupt data!");
            }
            int j2 = 0;
            while (j2 < dimensions) {
                t = points[i][j2];
                if (t < mins[j2]) {
                    mins[j2] = t;
                }
                if (t > maxs[j2]) {
                    maxs[j2] = t;
                }
                int n = j2++;
                averages[n] = averages[n] + t;
            }
        }
        int best_one = 0;
        int second_one = 0;
        for (j = 0; j < dimensions; ++j) {
            averages[j] = averages[j] / (float)projection.length;
            normalized_averages[j] = (averages[j] - mins[j]) / (maxs[j] - mins[j]);
        }
        for (j = 0; j < dimensions; ++j) {
            for (int i = 0; i < projection.length; ++i) {
                t = points[i][j] - averages[j];
                int n = j;
                variances[n] = variances[n] + t * t;
                t = (points[i][j] - mins[j]) / (maxs[j] - mins[j]) - normalized_averages[j];
                int n2 = j;
                normalized_variances[n2] = normalized_variances[n2] + t * t;
            }
            variances[j] = variances[j] / (float)projection.length;
            normalized_variances[j] = normalized_variances[j] / (float)projection.length;
        }
        for (j = 0; j < dimensions; ++j) {
            if (normalized_variances[j] >= normalized_variances[best_one]) {
                second_one = best_one;
                best_one = j;
                continue;
            }
            if (!(normalized_variances[j] >= normalized_variances[second_one])) continue;
            second_one = j;
        }
        for (int i = 0; i < projection.length; ++i) {
            projection[i][0] = points[i][best_one];
            projection[i][1] = points[i][second_one];
        }
        return projection;
    }

    public float iteration(DistanceMatrix dmatRn, float[][] projection) throws IOException {
        int j;
        int i;
        int nrPoints = dmatRn.getElementCount();
        float sumSquareMeanError = 0.0f;
        float error = 0.0f;
        float sumDistRn = 0.0f;
        float sumInDer1 = 0.0f;
        float sumInDer2 = 0.0f;
        float delta_pq = 0.0f;
        float c = 0.0f;
        float[][] projection_aux = new float[projection.length][];
        for (i = 0; i < projection.length; ++i) {
            projection_aux[i] = new float[2];
            projection_aux[i][0] = projection[i][0];
            projection_aux[i][1] = projection[i][1];
        }
        for (i = 0; i < nrPoints - 1; ++i) {
            for (j = i + 1; j < nrPoints; ++j) {
                if (dmatRn.getDistance(i, j) < 1.0E-6f) {
                    dmatRn.setDistance(i, j, 1.0E-6f);
                }
                sumDistRn += dmatRn.getDistance(i, j);
            }
        }
        c = -2.0f / sumDistRn;
        for (int p = 0; p < nrPoints; ++p) {
            int q = 0;
            while (q < 2) {
                sumInDer1 = 0.0f;
                sumInDer2 = 0.0f;
                for (int j2 = 0; j2 < nrPoints; ++j2) {
                    if (j2 == p) continue;
                    float distPJ = this.distR2(projection_aux[p], projection_aux[j2]);
                    sumInDer1 += (dmatRn.getDistance(p, j2) - distPJ) / (dmatRn.getDistance(p, j2) * distPJ) * (projection[p][q] - projection[j2][q]);
                    sumInDer2 = (float)((double)sumInDer2 + (double)(1.0f / (dmatRn.getDistance(p, j2) * distPJ)) * ((double)(dmatRn.getDistance(p, j2) - distPJ) - Math.pow(projection[p][q] - projection[j2][q], 2.0) / (double)distPJ * (double)(1.0f + (dmatRn.getDistance(p, j2) - distPJ) / distPJ)));
                }
                delta_pq = c * sumInDer1 / Math.abs(c * sumInDer2);
                float[] fArray = projection[p];
                int n = q++;
                fArray[n] = fArray[n] - this.MF * delta_pq;
            }
        }
        for (i = 0; i < dmatRn.getElementCount() - 1; ++i) {
            for (j = i + 1; j < dmatRn.getElementCount(); ++j) {
                sumSquareMeanError = (float)((double)sumSquareMeanError + Math.pow(dmatRn.getDistance(i, j) - this.distR2(projection[i], projection[j]), 2.0) / (double)dmatRn.getDistance(i, j));
            }
        }
        error = 1.0f / sumDistRn * sumSquareMeanError;
        return error;
    }

    private float distR2(float[] pointA, float[] pointB) {
        float x1x2 = pointA[0] - pointB[0];
        float y1y2 = pointA[1] - pointB[1];
        float dist = (float)Math.sqrt(x1x2 * x1x2 + y1y2 * y1y2);
        if (dist > 1.0E-6f) {
            return dist;
        }
        return 1.0E-6f;
    }
}

