/*
 * Decompiled with CFR 0.152.
 */
package visualizer.textprocessing;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import visualizer.textprocessing.WeightedWord;
import visualizer.util.SystemPropertiesManager;

public class Startword {
    private List<WeightedWord> startwords;
    private static Startword instance;
    private String filename;

    private Startword(String filename) throws IOException {
        this.readStartwordList(filename);
    }

    public static Startword getInstance() throws IOException {
        if (instance == null) {
            SystemPropertiesManager m = SystemPropertiesManager.getInstance();
            String staFilename = m.getProperty("STW.FILE");
            File f = new File(staFilename);
            if (!f.exists() || m.getProperty("STW.FILE").trim().length() < 1) {
                staFilename = "config/startwords.stw";
                m.setProperty("STW.FILE", staFilename);
            }
            instance = new Startword(staFilename);
        }
        return instance;
    }

    public void changeStartwordList(String staFilename) throws IOException {
        this.readStartwordList(staFilename);
    }

    public List<WeightedWord> getStartwordList() {
        return this.startwords;
    }

    public void addStartwords(List<String> newStartwords) {
        for (String newStartword : newStartwords) {
            if (this.isStartWord(newStartword)) continue;
            this.startwords.add(new WeightedWord(newStartword.toLowerCase(), new Double(1.0)));
        }
        Collections.sort(this.startwords);
    }

    public void addStartword(String newStartword, Double weight) {
        if (!this.isStartWord(newStartword)) {
            this.startwords.add(new WeightedWord(newStartword.toLowerCase(), weight));
        }
        Collections.sort(this.startwords);
    }

    public void removeStartword(String startword) {
        this.startwords.remove(startword);
    }

    public void saveStartwordsList(String filename) throws IOException {
        this.filename = filename;
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(filename));
            for (WeightedWord startword : this.startwords) {
                out.write(startword.word + " ; " + startword.weight);
                out.write("\n");
            }
        }
        catch (IOException ex) {
            throw new IOException("Problems saving \"" + filename + "\" file!");
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean isStartWord(String word) {
        return Collections.binarySearch(this.startwords, WeightedWord.newInstance(word, 1.0)) >= 0;
    }

    public Double getWeight(String word) {
        int index = Collections.binarySearch(this.startwords, WeightedWord.newInstance(word, 1.0));
        if (index >= 0) {
            return this.startwords.get((int)index).weight;
        }
        return 0.0;
    }

    private void readStartwordList(String filename) throws IOException {
        this.filename = filename;
        BufferedReader in = null;
        this.startwords = new ArrayList<WeightedWord>();
        try {
            in = new BufferedReader(new FileReader(filename));
            String line = null;
            while ((line = in.readLine()) != null && line.trim().length() > 0) {
                if (line.contains(";")) {
                    String word = line.split(";")[0].trim();
                    Double weight = new Double(line.split(";")[1]);
                    this.startwords.add(new WeightedWord(word.toLowerCase(), weight));
                    continue;
                }
                this.startwords.add(new WeightedWord(line.toLowerCase(), new Double(1.0)));
            }
        }
        catch (FileNotFoundException e) {
            throw new IOException("File \"" + filename + "\" was not found!");
        }
        catch (IOException e) {
            throw new IOException("Problems reading the file \"" + filename + "\"");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        Collections.sort(this.startwords);
    }
}

