/*
 * Decompiled with CFR 0.152.
 */
package visualizer.textprocessing.stemmer;

import org.tartarus.snowball.ext.englishStemmer;
import org.tartarus.snowball.ext.frenchStemmer;
import org.tartarus.snowball.ext.porterStemmer;
import org.tartarus.snowball.ext.portugueseStemmer;
import org.tartarus.snowball.ext.spanishStemmer;
import visualizer.textprocessing.stemmer.NullStemmer;
import visualizer.textprocessing.stemmer.SnowBallWrapper;
import visualizer.textprocessing.stemmer.Stemmer;
import visualizer.textprocessing.stemmer.StemmerType;

public class StemmerFactory {
    public static Stemmer getInstance(StemmerType type) {
        if (type == StemmerType.PORTER) {
            return new SnowBallWrapper(porterStemmer.class);
        }
        if (type == StemmerType.ENGLISH) {
            return new SnowBallWrapper(englishStemmer.class);
        }
        if (type == StemmerType.PORTUGUESE) {
            return new SnowBallWrapper(portugueseStemmer.class);
        }
        if (type == StemmerType.SPANISH) {
            return new SnowBallWrapper(spanishStemmer.class);
        }
        if (type == StemmerType.FRENCH) {
            return new SnowBallWrapper(frenchStemmer.class);
        }
        return new NullStemmer();
    }
}

