/*
 * Decompiled with CFR 0.152.
 */
package visualizer.textprocessing.transformation;

import visualizer.matrix.Matrix;
import visualizer.matrix.SparseVector;
import visualizer.textprocessing.transformation.MatrixTransformation;

public class TFIDFTransformation
implements MatrixTransformation {
    @Override
    public Matrix tranform(Matrix matrix, Object parameter) {
        int col;
        int svlength;
        SparseVector sv;
        int lin;
        float[] docsFreq = new float[matrix.getDimensions()];
        for (lin = 0; lin < matrix.getRowCount(); ++lin) {
            sv = (SparseVector)matrix.getRow(lin);
            svlength = sv.getIndex().length;
            for (col = 0; col < svlength; ++col) {
                int n = sv.getIndex()[col];
                docsFreq[n] = docsFreq[n] + 1.0f;
            }
        }
        for (lin = 0; lin < matrix.getRowCount(); ++lin) {
            sv = (SparseVector)matrix.getRow(lin);
            sv.shouldUpdateNorm();
            svlength = sv.getIndex().length;
            for (col = 0; col < svlength; ++col) {
                float tf = sv.getValues()[col];
                float idf = 0.0f;
                if (docsFreq[col] != 0.0f) {
                    idf = (float)Math.log((float)matrix.getRowCount() / docsFreq[sv.getIndex()[col]]);
                }
                sv.getValues()[col] = tf * idf;
            }
        }
        return matrix;
    }
}

