/*
 * Decompiled with CFR 0.152.
 */
package visualizer.tools.apriori;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import visualizer.tools.apriori.ItemSet;
import visualizer.tools.apriori.StemDescription;
import visualizer.tools.apriori.Transaction;

public class MyTreeNode {
    private ArrayList bucket;
    private HashMap children;
    private List<Integer> itemsRef;
    StemDescription[] stemDescriptors;
    private int treeLevel;
    private int bucketSize;
    private int stemNum;

    public MyTreeNode(int buckSize, int stems, List<Integer> itemsReference, StemDescription[] stemDescs, int level) {
        this.stemNum = stems;
        this.bucketSize = buckSize;
        this.stemDescriptors = stemDescs;
        this.children = new HashMap();
        this.bucket = new ArrayList(this.bucketSize);
        this.itemsRef = itemsReference;
        this.treeLevel = level;
    }

    public void addItemset(ItemSet itemset) {
        if (this.treeLevel < itemset.size()) {
            int count;
            Integer currentItem = itemset.getItem(this.treeLevel);
            for (count = 0; count < this.stemDescriptors.length && !this.stemDescriptors[count].keyExists(currentItem); ++count) {
            }
            Character currentStemID = this.stemDescriptors[count].getID();
            if (this.children.containsKey(currentStemID)) {
                ((MyTreeNode)this.children.get(currentStemID)).addItemset(itemset);
            } else {
                MyTreeNode newBucket = new MyTreeNode(this.bucketSize, this.stemNum, this.itemsRef, this.stemDescriptors, this.treeLevel + 1);
                newBucket.addItemset(itemset);
                this.children.put(currentStemID, newBucket);
            }
        } else {
            this.bucket.add(itemset);
        }
    }

    public ArrayList getBucketItemsets() {
        return this.bucket;
    }

    public void returnBucketItemsets(ArrayList newBucket) {
        this.bucket = newBucket;
    }

    public void printContents() {
        int count;
        System.out.println("level " + this.treeLevel + " bucket contents:");
        for (count = 0; count < this.bucket.size(); ++count) {
            ItemSet currentItemset = (ItemSet)this.bucket.get(count);
            List<Integer> currentItemsetItems = currentItemset.getItems();
            ListIterator<Integer> itItems = currentItemsetItems.listIterator(0);
            while (itItems.hasNext()) {
                System.out.print(itItems.next());
            }
            System.out.print(", support " + currentItemset.getSupport() + "|");
        }
        System.out.println("\nchildren contents:");
        for (count = 0; count < this.stemDescriptors.length; ++count) {
            if (!this.children.containsKey(this.stemDescriptors[count].getID())) continue;
            MyTreeNode currentChild = (MyTreeNode)this.children.get(this.stemDescriptors[count].getID());
            currentChild.printContents();
        }
        System.out.println("**************************");
    }

    public ArrayList getChildren() {
        return new ArrayList(this.children.values());
    }

    public void passTransaction(Transaction transaction, int activeLevel) {
        if (this.treeLevel == activeLevel) {
            for (int arrayPos = 0; arrayPos < this.bucket.size(); ++arrayPos) {
                if (!transaction.isThisSubset(((ItemSet)this.bucket.get(arrayPos)).getItems())) continue;
                ((ItemSet)this.bucket.get(arrayPos)).incrementSupport();
            }
        }
        this.passTransactionOverChildren(transaction, activeLevel);
    }

    public void passTransactionOverChildren(Transaction transaction, int activeLevel) {
        for (int count = 0; count < this.stemDescriptors.length; ++count) {
            if (!this.children.containsKey(this.stemDescriptors[count].getID())) continue;
            ((MyTreeNode)this.children.get(this.stemDescriptors[count].getID())).passTransaction(transaction, activeLevel);
        }
    }

    public void removeInfrequentItemsets(float minSup) {
        ArrayList itemsetsToRemove = new ArrayList();
        for (int bucketPos = 0; bucketPos < this.bucket.size(); ++bucketPos) {
            if (!((float)((ItemSet)this.bucket.get(bucketPos)).getSupport() < minSup)) continue;
            itemsetsToRemove.add(this.bucket.get(bucketPos));
        }
        for (int removeCount = 0; removeCount < itemsetsToRemove.size(); ++removeCount) {
            this.bucket.remove(this.bucket.indexOf(itemsetsToRemove.get(removeCount)));
        }
        this.removeChildrenInfrequentItemsets(minSup);
    }

    public void removeChildrenInfrequentItemsets(float minSup) {
        for (int count = 0; count < this.stemDescriptors.length; ++count) {
            if (!this.children.containsKey(this.stemDescriptors[count].getID())) continue;
            ((MyTreeNode)this.children.get(this.stemDescriptors[count].getID())).removeInfrequentItemsets(minSup);
        }
    }

    public ArrayList getItemsets(int levelRequired) {
        ArrayList itemsets = new ArrayList();
        if (this.treeLevel == levelRequired) {
            itemsets.addAll(this.bucket);
        }
        for (int count = 0; count < this.stemDescriptors.length; ++count) {
            if (!this.children.containsKey(this.stemDescriptors[count].getID())) continue;
            itemsets.addAll(((MyTreeNode)this.children.get(this.stemDescriptors[count].getID())).getItemsets(levelRequired));
        }
        return itemsets;
    }

    public ArrayList getAllItemsets() {
        ArrayList itemsets = new ArrayList();
        itemsets.addAll(this.bucket);
        for (int count = 0; count < this.stemDescriptors.length; ++count) {
            if (!this.children.containsKey(this.stemDescriptors[count].getID())) continue;
            itemsets.addAll(((MyTreeNode)this.children.get(this.stemDescriptors[count].getID())).getAllItemsets());
        }
        return itemsets;
    }
}

