/*
 * Decompiled with CFR 0.152.
 */
package visualizer.tools.apriori;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import visualizer.corpus.Corpus;
import visualizer.graph.Vertex;
import visualizer.tools.apriori.ItemSet;
import visualizer.tools.apriori.NLPTools;
import visualizer.tools.apriori.TopicInterface;
import visualizer.topic.TopicData;

public class RuleSet
implements TopicInterface {
    public Set<ItemSet> rules;
    public boolean[] coveredPoints;
    float[][] allPoints;
    private Set<String> termSet;
    private int supportGlobal = 0;
    private String strongPhrase = null;
    private String shortStrongPhrase = null;
    private ArrayList<Vertex> relatedVertices;

    public RuleSet(float[][] allPoints) {
        this.allPoints = allPoints;
        int corpusSize = allPoints.length;
        this.coveredPoints = new boolean[corpusSize];
        for (int j = 0; j < this.coveredPoints.length; ++j) {
            this.coveredPoints[j] = false;
        }
        this.rules = new HashSet<ItemSet>();
        this.termSet = new HashSet<String>();
    }

    void add(ItemSet iS) {
        this.supportGlobal += iS.setCovered(this.allPoints, this.coveredPoints, false);
        this.rules.add(iS);
        this.termSet.addAll(iS.getTerms());
    }

    public String extractStrongestPhrase(String fullText, List<String> ngramList, TopicData tdata, boolean isShortPhrase) {
        String[] phrases = NLPTools.simplePhraseSpliter(fullText);
        String strongPhrase = null;
        Float strongestWeight = Float.valueOf(Float.MIN_VALUE);
        for (String phrase : phrases) {
            float contains = this.phraseWeight(phrase, ngramList, tdata, isShortPhrase);
            if (!(contains > strongestWeight.floatValue())) continue;
            strongPhrase = phrase;
            strongestWeight = Float.valueOf(contains);
        }
        return strongPhrase;
    }

    public float phraseWeight(String phrase, List<String> ngramList, TopicData tdata, boolean isShortPhrase) {
        float contains = 0.0f;
        for (String ngram : ngramList) {
            contains += phrase.toLowerCase().indexOf(ngram.toLowerCase()) != -1 ? 1.0f : 0.0f;
        }
        if (isShortPhrase) {
            int wordCount = phrase.split("\\s").length;
            return contains - ((float)wordCount - contains + 1.0f) / 1000.0f;
        }
        return contains;
    }

    public String computeStrongPhrase(float[][] allPoints, TopicData tdata, boolean isShortPhrase) {
        Corpus datasource = tdata.getCorpus();
        String phrase = null;
        String strongPhrase = null;
        Float strongestWeight = Float.valueOf(Float.MIN_VALUE);
        for (int i = 0; i < allPoints.length; ++i) {
            if (!this.coveredPoints[i]) continue;
            String fullText = "error";
            try {
                fullText = datasource.getFullContent(datasource.getIds().get(i));
                phrase = this.extractStrongestPhrase(fullText, new ArrayList<String>(this.termSet), tdata, isShortPhrase);
            }
            catch (IOException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            }
            float phraseWeight = this.phraseWeight(phrase, new ArrayList<String>(this.termSet), tdata, isShortPhrase);
            if (phrase == null || !(phraseWeight > strongestWeight.floatValue())) continue;
            strongPhrase = phrase;
            strongestWeight = Float.valueOf(phraseWeight);
        }
        if (strongPhrase != null) {
            if (isShortPhrase) {
                this.shortStrongPhrase = strongPhrase;
            } else {
                this.strongPhrase = strongPhrase;
            }
            return strongPhrase;
        }
        this.strongPhrase = "";
        return this.toString();
    }

    public String getTopic(TopicData ldata) {
        String topic = "";
        if (ldata.isShortPhrase()) {
            topic = topic + this.shortStrongPhrase + " ";
        }
        if (ldata.isPhrase()) {
            topic = topic + this.strongPhrase + " ";
        }
        if (ldata.isRuleTopic()) {
            topic = topic + this.toString() + " ";
        }
        return topic;
    }

    public String toString() {
        ItemSet[] ruleArray = this.rules.toArray(new ItemSet[0]);
        HashSet<String> termSet = new HashSet<String>();
        HashSet headTermSet = new HashSet();
        int maxSupportIndex = -1;
        int maxSupport = 0;
        for (int i = 0; i < ruleArray.length; ++i) {
            if (ruleArray[i].getSupport() > maxSupport) {
                maxSupport = ruleArray[i].getSupport();
                maxSupportIndex = i;
            }
            termSet.addAll(ruleArray[i].getTerms());
        }
        String topic = "";
        topic = topic + "::" + ruleArray[maxSupportIndex].toString();
        termSet.removeAll(ruleArray[maxSupportIndex].getTerms());
        topic = topic + ((Object)termSet).toString().replaceAll("\\[|\\]", ":");
        return topic;
    }

    public Set<String> getTermSet() {
        return this.termSet;
    }

    public void setTermSet(Set<String> termSet) {
        this.termSet = termSet;
    }

    public int getSupportGlobal() {
        return this.supportGlobal;
    }

    public float getMaxConfidence() {
        float maxConfidence = Float.MIN_VALUE;
        ItemSet[] ruleArray = this.rules.toArray(new ItemSet[0]);
        for (int i = 0; i < ruleArray.length; ++i) {
            if (!(ruleArray[i].getMaxConfidence().floatValue() > maxConfidence)) continue;
            maxConfidence = ruleArray[i].getMaxConfidence().floatValue();
        }
        return maxConfidence;
    }

    public float getMinConfidence() {
        float minConfidence = Float.MAX_VALUE;
        ItemSet[] ruleArray = this.rules.toArray(new ItemSet[0]);
        for (int i = 0; i < ruleArray.length; ++i) {
            if (!(ruleArray[i].getMaxConfidence().floatValue() < minConfidence)) continue;
            minConfidence = ruleArray[i].getMaxConfidence().floatValue();
        }
        return minConfidence;
    }

    public float getAvgWeight() {
        float weightSum = 0.0f;
        ItemSet[] ruleArray = this.rules.toArray(new ItemSet[0]);
        for (int i = 0; i < ruleArray.length; ++i) {
            weightSum += ruleArray[i].getSumTfIdf();
        }
        return weightSum / (float)this.rules.size();
    }

    public String getTermString() {
        ArrayList<String> terms = new ArrayList<String>(this.termSet);
        Collections.sort(terms);
        StringBuffer termString = new StringBuffer("");
        for (String st : terms) {
            termString.append(st);
        }
        return termString.toString();
    }

    @Override
    public boolean isPart(TopicInterface topic) {
        return topic.getTerms().containsAll(this.getTerms());
    }

    @Override
    public List<String> getTerms() {
        return new ArrayList<String>(this.getTermSet());
    }

    @Override
    public ArrayList<Vertex> getRelatedVertices() {
        return this.relatedVertices;
    }

    public void setRelatedVertices(ArrayList<Vertex> relatedVertices) {
        this.relatedVertices = relatedVertices;
    }
}

