/*
 * Decompiled with CFR 0.152.
 */
package visualizer.topic;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import visualizer.graph.Graph;
import visualizer.topic.TopicData;

public class CovarianceTopicSettings
extends JDialog {
    private static CovarianceTopicSettings instance;
    private Graph graph;
    private JPanel buttonPanel;
    private JButton cancekButton;
    private JButton closeButton;
    private JPanel parametersPanel;
    private JLabel percentageTermsLabel;
    private JTextField percentageTermsTextField;
    private JLabel percentageTopicsLabel;
    private JTextField percentageTopicsTextField;

    private CovarianceTopicSettings(JDialog parent) {
        super(parent);
        this.initComponents();
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.closeButton = new JButton();
        this.cancekButton = new JButton();
        this.parametersPanel = new JPanel();
        this.percentageTermsLabel = new JLabel();
        this.percentageTopicsLabel = new JLabel();
        this.percentageTermsTextField = new JTextField();
        this.percentageTopicsTextField = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setTitle("Covariance Topics Settings");
        this.setModal(true);
        this.closeButton.setText("OK");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CovarianceTopicSettings.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.cancekButton.setText("Cancel");
        this.cancekButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CovarianceTopicSettings.this.cancekButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancekButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.parametersPanel.setBorder(BorderFactory.createTitledBorder("Parameters"));
        this.parametersPanel.setLayout(new GridBagLayout());
        this.percentageTermsLabel.setText("Percentage terms");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.parametersPanel.add((Component)this.percentageTermsLabel, gridBagConstraints);
        this.percentageTopicsLabel.setText("Percentage topics");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.parametersPanel.add((Component)this.percentageTopicsLabel, gridBagConstraints);
        this.percentageTermsTextField.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.parametersPanel.add((Component)this.percentageTermsTextField, gridBagConstraints);
        this.percentageTopicsTextField.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.parametersPanel.add((Component)this.percentageTopicsTextField, gridBagConstraints);
        this.getContentPane().add((Component)this.parametersPanel, "Center");
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.refreshData();
        this.setVisible(false);
    }

    private void cancekButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public static CovarianceTopicSettings getInstance(JDialog parent) {
        if (instance == null || instance.getParent() != parent) {
            instance = new CovarianceTopicSettings(parent);
        }
        return instance;
    }

    public void display(Graph graph) {
        this.graph = graph;
        TopicData tdata = graph.getTopicData();
        this.percentageTermsTextField.setText(Float.toString(tdata.getPercentageTerms()));
        this.percentageTopicsTextField.setText(Float.toString(tdata.getPercentageTopics()));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    private void refreshData() {
        TopicData tdata = this.graph.getTopicData();
        tdata.setPercentageTerms(Float.parseFloat(this.percentageTermsTextField.getText()));
        tdata.setPercentageTopics(Float.parseFloat(this.percentageTopicsTextField.getText()));
    }
}

