/*
 * Decompiled with CFR 0.152.
 */
package visualizer.topic;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import visualizer.corpus.Corpus;
import visualizer.graph.Vertex;
import visualizer.matrix.Matrix;
import visualizer.textprocessing.Ngram;
import visualizer.textprocessing.Preprocessor;
import visualizer.textprocessing.stemmer.StemmerType;
import visualizer.textprocessing.transformation.MatrixTransformation;
import visualizer.textprocessing.transformation.MatrixTransformationFactory;
import visualizer.tools.apriori.ItemSet;
import visualizer.tools.apriori.RuleSet;
import visualizer.tools.apriori.SelectedApriori;
import visualizer.topic.StringBox;
import visualizer.topic.Topic;
import visualizer.topic.TopicData;

public class RuleTopic
extends Topic {
    private TopicData tdata;
    private List<ItemSet> itemSets = null;
    private List<ItemSet> selectedItemSets = null;
    private List<RuleSet> ruleSetList = null;
    private ArrayList<Vertex> vertexRemainder = null;
    public String ruleDump = "";
    private StringBox selectedBox = null;
    private boolean ruleGroup = false;

    public RuleTopic(ArrayList<Vertex> vertex, Corpus corpus, TopicData tdata) {
        super(vertex);
        this.tdata = tdata;
        for (int i = 0; i < vertex.size(); ++i) {
            if (vertex.get(i).isValid()) continue;
            vertex.remove(i);
            --i;
        }
        this.createTopic(vertex, corpus);
    }

    @Override
    protected void createTopic(ArrayList<Vertex> vertex, Corpus corpus) {
        ArrayList<Ngram> corporaNgrams = null;
        try {
            StringBox box;
            ArrayList<Vertex> relatedVertices;
            float[][] points;
            if (this.tdata.getMatrix() == null) {
                Preprocessor pp = new Preprocessor(corpus);
                Matrix matrix = pp.getMatrix(this.tdata.getLunhLowerCut(), this.tdata.getLunhUpperCut(), this.tdata.getNumberGrams(), this.tdata.getStemmer(), this.tdata.isUseStopword());
                MatrixTransformation transf = MatrixTransformationFactory.getInstance(this.tdata.getMatrixTransformationType());
                matrix = transf.tranform(matrix, null);
                corporaNgrams = pp.getNgrams();
                points = matrix.toMatrix();
                this.tdata.setMatrix(matrix);
                this.tdata.setCorporaNgrams(corporaNgrams);
            } else {
                points = this.tdata.getMatrix().toMatrix();
                corporaNgrams = this.tdata.getCorporaNgrams();
            }
            this.tdata.setCorpus(corpus);
            this.ruleSetList = null;
            if (this.tdata.isGroupTopics()) {
                this.ruleSetList = new ArrayList<RuleSet>();
            }
            ArrayList<Vertex> vertexUsed = new ArrayList<Vertex>();
            ArrayList<Vertex> relatedVertex = new ArrayList<Vertex>();
            this.itemSets = new ArrayList<ItemSet>();
            this.selectedItemSets = new ArrayList<ItemSet>();
            System.out.println("**********Vertex: " + vertex.size());
            while (vertex != null && vertex.size() > 0) {
                float[][] selectedPoints = new float[vertex.size()][];
                int[] vertexIndex = new int[vertex.size()];
                int i = 0;
                for (int j = 0; j < vertex.size(); ++j) {
                    Vertex v = vertex.get(j);
                    if (corpus.getIds().get((int)v.getId()).equals(v.getUrl())) {
                        selectedPoints[i] = points[(int)v.getId()];
                        vertexIndex[i] = j;
                    } else {
                        System.err.println("Vertex not alligned to points matrix");
                        for (int k = 0; k < corpus.getIds().size(); ++k) {
                            if (!corpus.getIds().get(k).equals(v.getUrl())) continue;
                            selectedPoints[i] = points[k];
                            vertexIndex[i] = j;
                            break;
                        }
                    }
                    ++i;
                }
                Object[] ngrams = new Object[corporaNgrams.size()];
                for (int k = 0; k < corporaNgrams.size(); ++k) {
                    ngrams[k] = corporaNgrams.get((int)k).ngram;
                }
                SelectedApriori sApriori = new SelectedApriori(selectedPoints, points, ngrams);
                sApriori.setRuleSetList(this.ruleSetList);
                sApriori.setMinConf(90.0f);
                sApriori.setBeta(this.tdata.getWeightBeta().floatValue());
                sApriori.setLdata(this.tdata);
                sApriori.run();
                this.tdata.getTermSetAccum().addAll(sApriori.getTermSet());
                this.tdata.getTermSetRun().addAll(sApriori.getTermSet());
                this.tdata.getTermSetAccumW().addAll(sApriori.getTermSetW());
                this.tdata.getTermSetRunW().addAll(sApriori.getTermSetW());
                this.vertexRemainder = new ArrayList();
                this.itemSets.addAll(sApriori.getItemSets());
                this.selectedItemSets.addAll(sApriori.getSelectedItemSets());
                this.ruleDump = sApriori.ruleDump;
                for (int j = 0; j < sApriori.coveredPoints.length; ++j) {
                    if (!sApriori.coveredPoints[j]) {
                        this.vertexRemainder.add(vertex.get(vertexIndex[j]));
                        continue;
                    }
                    vertexUsed.add(vertex.get(vertexIndex[j]));
                }
                if (sApriori.getSelectedItemSets().size() > 0) {
                    vertex = this.vertexRemainder;
                    System.out.println("**********Remainder: " + this.vertexRemainder.size());
                    continue;
                }
                vertex = null;
            }
            if (!this.tdata.isGroupTopics()) {
                this.setRuleGroup(false);
                for (int k = 0; k < this.selectedItemSets.size(); ++k) {
                    String msg = this.selectedItemSets.get(k).getTopic(this.tdata);
                    relatedVertices = new ArrayList<Vertex>();
                    for (Integer index : this.selectedItemSets.get(k).getGlobalCoveredAllPoints()) {
                        relatedVertices.add(this.getVertexbyId(index));
                    }
                    this.selectedItemSets.get(k).setRelatedVertices(relatedVertices);
                    if (this.tdata.getStemmer() != StemmerType.NONE) {
                        msg = msg.replaceAll("<>", "");
                    }
                    box = new StringBox(msg, relatedVertices, this.selectedItemSets.get(k));
                    this.boxes.add(box);
                    relatedVertex.addAll(relatedVertices);
                }
            } else {
                this.setRuleGroup(true);
                for (int k = 0; k < this.ruleSetList.size(); ++k) {
                    this.ruleSetList.get(k).computeStrongPhrase(points, this.tdata, true);
                    this.ruleSetList.get(k).computeStrongPhrase(points, this.tdata, false);
                    String msg = this.ruleSetList.get(k).getTopic(this.tdata);
                    relatedVertices = new ArrayList();
                    for (int i = 0; i < this.ruleSetList.get((int)k).coveredPoints.length; ++i) {
                        if (!this.ruleSetList.get((int)k).coveredPoints[i]) continue;
                        relatedVertices.add(this.getVertexbyId(i));
                    }
                    this.ruleSetList.get(k).setRelatedVertices(relatedVertices);
                    if (this.tdata.getStemmer() != StemmerType.NONE) {
                        msg = msg.replaceAll("<>", "");
                    }
                    box = new StringBox(msg, relatedVertices, this.ruleSetList.get(k));
                    this.boxes.add(box);
                    relatedVertex.addAll(relatedVertices);
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public String getQuery() {
        if (this.boxes.size() < 1) {
            return "";
        }
        try {
            String query = "";
            Pattern p = Pattern.compile("\\[.*?\\]");
            Matcher m = p.matcher(((StringBox)this.boxes.get(0)).getMsg());
            while (m.find()) {
                query = query + " and " + m.group().replaceAll("\\[|\\]", "");
            }
            if (!query.equals("")) {
                query = query.replaceFirst(" and ", "");
                query = query.replaceAll("<>", "");
                return query;
            }
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public List<ItemSet> getItemSets() {
        return this.itemSets;
    }

    public void setItemSets(List<ItemSet> itemSets) {
        this.itemSets = itemSets;
    }

    public List<ItemSet> getSelectedItemSets() {
        return this.selectedItemSets;
    }

    public void setSelectedItemSets(List<ItemSet> selectedItemSets) {
        this.selectedItemSets = selectedItemSets;
    }

    public ArrayList<Vertex> getVertexRemainder() {
        return this.vertexRemainder;
    }

    @Override
    public void drawTopic(Graphics g, Font font, boolean selected) {
        Graphics2D g2 = (Graphics2D)g;
        g.setFont(font);
        FontMetrics metrics = g.getFontMetrics(g.getFont());
        g2.setStroke(new BasicStroke(1.3f));
        g2.setColor(Color.GRAY);
        g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g2.drawRect(this.rectangle.x, this.rectangle.y, this.rectangle.width, this.rectangle.height);
        g2.setStroke(new BasicStroke(1.0f));
        if (selected || showTopics || this.showThisTopic) {
            if (selected) {
                g2.setComposite(AlphaComposite.getInstance(3, 0.2f));
                g2.setPaint(Color.BLUE);
                g.fillRect(this.rectangle.x, this.rectangle.y, this.rectangle.width, this.rectangle.height);
            }
            if (this.boxes.size() > 0) {
                Point position = new Point();
                position.x = this.rectangle.x + this.rectangle.width;
                position.y = this.rectangle.y;
                Rectangle rect = this.drawBox(g2, font, position, (StringBox)this.boxes.get(0), selected);
                for (int i = 1; i < this.boxes.size(); ++i) {
                    position = new Point();
                    position.x = this.rectangle.x + this.rectangle.width;
                    position.y = rect.y + rect.height + 6;
                    rect = this.drawBox(g2, font, position, (StringBox)this.boxes.get(i), selected);
                }
            }
        }
    }

    private Rectangle drawBox(Graphics2D g2, Font font, Point position, StringBox box, boolean selected) {
        Color c;
        Rectangle rect;
        if (selected || box == this.selectedBox) {
            rect = box.draw(g2, position, font, true);
            c = Color.BLUE;
            for (Vertex v : box.getRelatedVertices()) {
                v.setSelected(true);
                v.draw(g2, false);
            }
        } else {
            rect = box.draw(g2, position, font, false);
            c = Color.GREEN;
        }
        Point setPosition = this.calcVertexSetPosition(box.getRelatedVertices());
        this.drawDiamond(g2, setPosition, c);
        this.drawTopicLine(g2, position, setPosition, c);
        return rect;
    }

    private Vertex getVertexbyId(Integer index) {
        for (Vertex v : this.tdata.getGraph().getVertex()) {
            if (v.getId() != (long)index.intValue()) continue;
            return v;
        }
        return null;
    }

    private void drawDiamond(Graphics2D g2, Point p, Color color) {
        float halfSize = 2.0f;
        int[] x = new int[4];
        int[] y = new int[4];
        x[0] = (int)((float)p.x - halfSize);
        x[1] = p.x;
        x[2] = (int)((float)p.x + halfSize);
        x[3] = p.x;
        y[0] = p.y;
        y[1] = (int)((float)p.y - halfSize);
        y[2] = p.y;
        y[3] = (int)((float)p.y + halfSize);
        g2.setColor(color);
        g2.drawPolygon(x, y, 4);
    }

    private Point calcVertexSetPosition(List<Vertex> vertex) {
        Point p = new Point();
        p.x = 0;
        p.y = 0;
        for (Vertex v : vertex) {
            p.x += (int)v.getX();
            p.y += (int)v.getY();
        }
        p.x = (int)((float)p.x / (1.0f * (float)vertex.size()));
        p.y = (int)((float)p.y / (1.0f * (float)vertex.size()));
        return p;
    }

    private void drawTopicLine(Graphics2D g2, Point p1, Point p2, Color color) {
        g2.setStroke(new BasicStroke(1.0f, 2, 2, 10.0f, new float[]{9.0f}, 0.0f));
        g2.setColor(color);
        g2.drawLine(p1.x, p1.y, p2.x, p2.y);
        g2.setStroke(new BasicStroke());
    }

    @Override
    public boolean isBoxInside(Point point) {
        for (StringBox box : this.boxes) {
            if (!box.isInside(point)) continue;
            this.selectedBox = box;
            return true;
        }
        return false;
    }

    public TopicData getTopicData() {
        return this.tdata;
    }

    public boolean isRuleGroup() {
        return this.ruleGroup;
    }

    public void setRuleGroup(boolean ruleGroup) {
        this.ruleGroup = ruleGroup;
    }

    public List<RuleSet> getRuleSetList() {
        return this.ruleSetList;
    }

    public void setRuleSetList(List<RuleSet> ruleSetList) {
        this.ruleSetList = ruleSetList;
    }
}

