/*
 * Decompiled with CFR 0.152.
 */
package visualizer.topic;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import visualizer.corpus.Corpus;
import visualizer.graph.Vertex;
import visualizer.topic.StringBox;

public abstract class Topic {
    protected ArrayList<StringBox> boxes = new ArrayList();
    protected Rectangle rectangle;
    protected static boolean showTopics = false;
    protected boolean showThisTopic = false;

    public Topic(ArrayList<Vertex> vertex) {
        this.calculateRectangle(vertex);
        for (int i = 0; i < vertex.size(); ++i) {
            if (vertex.get(i).isValid()) continue;
            vertex.remove(i);
            --i;
        }
    }

    public void drawTopic(Graphics g, Font font, boolean selected) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setFont(font);
        g2.setStroke(new BasicStroke(1.3f));
        g2.setColor(Color.GRAY);
        g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g2.drawRect(this.rectangle.x, this.rectangle.y, this.rectangle.width, this.rectangle.height);
        g2.setStroke(new BasicStroke(1.0f));
        if (selected || showTopics || this.showThisTopic) {
            if (selected) {
                g2.setComposite(AlphaComposite.getInstance(3, 0.2f));
                g2.setPaint(Color.BLUE);
                g2.fillRect(this.rectangle.x, this.rectangle.y, this.rectangle.width, this.rectangle.height);
            }
            if (this.boxes.size() > 0) {
                Point position = new Point();
                position.x = this.rectangle.x + this.rectangle.width / 2;
                position.y = this.rectangle.y;
                Rectangle rect = this.boxes.get(0).draw(g2, position, font, selected);
                for (int i = 1; i < this.boxes.size(); ++i) {
                    position = new Point();
                    position.x = this.rectangle.x + this.rectangle.width / 2;
                    position.y = rect.y + rect.height + 6;
                    rect = this.boxes.get(i).draw(g2, position, font, selected);
                }
            }
        }
    }

    public Rectangle getRectangle() {
        return this.rectangle;
    }

    public float weightDistance(Point point) {
        if (this.isInside(point)) {
            int cx = this.rectangle.x + this.rectangle.width / 2;
            int cy = this.rectangle.y + this.rectangle.height / 2;
            return (float)(Math.sqrt((cx - point.x) * (cx - point.x) + (cy - point.y) * (cy - point.y)) * (double)this.rectangle.width);
        }
        return -1.0f;
    }

    public boolean isInside(Point point) {
        return point.x > this.rectangle.x && point.x < this.rectangle.x + this.rectangle.width && point.y > this.rectangle.y && point.y < this.rectangle.y + this.rectangle.height;
    }

    public static boolean isShowTopics() {
        return showTopics;
    }

    public static void setShowTopics(boolean aShowTopics) {
        showTopics = aShowTopics;
    }

    public boolean isShowThisTopic() {
        return this.showThisTopic;
    }

    public void setShowThisTopic(boolean showThisTopic) {
        this.showThisTopic = showThisTopic;
    }

    public String getQuery() {
        return null;
    }

    protected void calculateRectangle(ArrayList<Vertex> vertex) {
        this.rectangle = this.calcRect(vertex);
    }

    protected Rectangle calcRect(ArrayList<Vertex> vertex) {
        Rectangle rect = new Rectangle();
        if (vertex.size() > 0) {
            int maxX = (int)vertex.get(0).getX();
            int minX = (int)vertex.get(0).getX();
            int maxY = (int)vertex.get(0).getY();
            int minY = (int)vertex.get(0).getY();
            for (int v = 1; v < vertex.size(); ++v) {
                int x = (int)vertex.get(v).getX();
                int y = (int)vertex.get(v).getY();
                if (x > maxX) {
                    maxX = x;
                } else if (x < minX) {
                    minX = x;
                }
                if (y > maxY) {
                    maxY = y;
                    continue;
                }
                if (y >= minY) continue;
                minY = y;
            }
            rect.x = minX - vertex.get(0).getRayBase() - 2;
            rect.y = minY - vertex.get(0).getRayBase() - 2;
            rect.width = maxX - minX + vertex.get(0).getRayBase() * 2 + 4;
            rect.height = maxY - minY + vertex.get(0).getRayBase() * 2 + 4;
            return rect;
        }
        rect.x = -1;
        rect.y = -1;
        rect.width = 0;
        rect.height = 0;
        return rect;
    }

    protected abstract void createTopic(ArrayList<Vertex> var1, Corpus var2);

    public boolean isBoxInside(Point point) {
        return false;
    }
}

