/*
 * Decompiled with CFR 0.152.
 */
package visualizer.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import visualizer.matrix.DenseMatrix;
import visualizer.matrix.DenseVector;

public class Converter {
    public void data(String datafile, String namesfile) throws IOException {
        ArrayList points = new ArrayList();
        ArrayList<String> attributes = new ArrayList<String>();
        BufferedReader in = null;
        try {
            StringTokenizer t;
            in = new BufferedReader(new FileReader(datafile));
            String line = null;
            while ((line = in.readLine()) != null && line.trim().length() > 0) {
                if (line.lastIndexOf(35) != -1) continue;
                t = new StringTokenizer(line, ";");
                while (t.hasMoreTokens()) {
                    String token = t.nextToken();
                    attributes.add(token.trim());
                }
                break block10;
            }
            while ((line = in.readLine()) != null && line.trim().length() > 1) {
                if (line.lastIndexOf(35) != -1) continue;
                t = new StringTokenizer(line, ";");
                ArrayList<Float> point = new ArrayList<Float>();
                while (t.hasMoreTokens()) {
                    String token = t.nextToken();
                    point.add(Float.valueOf(Float.parseFloat(token)));
                }
                points.add(point);
            }
        }
        catch (FileNotFoundException e) {
            throw new IOException("File " + datafile + " does not exist!");
        }
        catch (IOException e) {
            throw new IOException("Problems reading the file " + datafile + " : " + e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(Converter.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        ArrayList<String> names = null;
        if (namesfile != null) {
            names = this.readNames(namesfile);
        }
        if (attributes.size() > ((ArrayList)points.get(0)).size() - 1) {
            attributes.remove(attributes.size() - 1);
        }
        DenseMatrix matrix = new DenseMatrix();
        matrix.setAttributes(attributes);
        for (int i = 0; i < points.size(); ++i) {
            float[] point = new float[((ArrayList)points.get(i)).size() - 1];
            for (int j = 0; j < ((ArrayList)points.get(i)).size() - 1; ++j) {
                point[j] = ((Float)((ArrayList)points.get(i)).get(j)).floatValue();
            }
            float cdata = ((Float)((ArrayList)points.get(i)).get(((ArrayList)points.get(i)).size() - 1)).floatValue();
            if (names != null) {
                matrix.addRow(new DenseVector(point, names.get(i), cdata));
                continue;
            }
            matrix.addRow(new DenseVector(point, Integer.toString(i), cdata));
        }
        matrix.save(datafile.replaceAll(".data", "") + "_new.data");
    }

    private ArrayList<String> readNames(String namesfile) throws IOException {
        ArrayList<String> names = new ArrayList<String>();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(namesfile));
            String line = null;
            while ((line = in.readLine()) != null) {
                if (line.trim().length() <= 0) continue;
                names.add(line.trim());
            }
        }
        catch (FileNotFoundException e) {
            throw new IOException("File \"" + namesfile + "\" was not found!");
        }
        catch (IOException e) {
            throw new IOException("Problems reading the file \"" + namesfile + "\"");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(Converter.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return names;
    }

    public static void main(String[] args) {
        try {
            String datafile = "D:\\My Documents\\FERNANDO\\development2_Normalized.data";
            String namesfile = "D:\\My Documents\\FERNANDO\\development2_Normalized.names";
            Converter conv = new Converter();
            conv.data(datafile, namesfile);
        }
        catch (IOException ex) {
            Logger.getLogger(Converter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

