/*
 * Decompiled with CFR 0.152.
 */
package visualizer.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import visualizer.projection.distance.DistanceMatrix;
import visualizer.util.Pair;
import visualizer.util.Prim;

public class Dijkstra {
    private int n;
    private float[][] dist;
    private float[] d;

    public Dijkstra(Pair[][] neighborhood, int nrNodes) {
        this.n = nrNodes;
        this.d = new float[this.n];
        this.dist = new float[this.n][];
        for (int i = 0; i < neighborhood.length; ++i) {
            this.dist[i] = new float[this.n];
            Arrays.fill(this.dist[i], 0.0f);
            for (int j = 0; j < neighborhood[i].length; ++j) {
                float distance = neighborhood[i][j].value;
                if (!(distance > 0.0f)) continue;
                this.dist[i][neighborhood[i][j].index] = distance;
            }
        }
    }

    public float[] execute(int source) {
        boolean[] visited = new boolean[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.d[i] = Float.POSITIVE_INFINITY;
            visited[i] = false;
        }
        this.d[source] = 0.0f;
        for (int k = 0; k < this.n; ++k) {
            int i;
            int mini = -1;
            for (i = 0; i < this.n; ++i) {
                if (visited[i] || mini != -1 && !(this.d[i] < this.d[mini])) continue;
                mini = i;
            }
            visited[mini] = true;
            for (i = 0; i < this.n; ++i) {
                if (!(this.dist[mini][i] > 0.0f) || !(this.d[mini] + this.dist[mini][i] < this.d[i])) continue;
                this.d[i] = this.d[mini] + this.dist[mini][i];
            }
        }
        return this.d;
    }

    public static void main(String[] args) {
        try {
            String filename = "C:\\Documents and Settings\\paulovich\\Mijn documenten\\cbr-ilp-ir_gzip.dmat";
            DistanceMatrix dmat = new DistanceMatrix(filename);
            DistanceMatrix new_dmat = new DistanceMatrix(dmat.getElementCount());
            Prim prim = new Prim(dmat);
            ArrayList<Prim.Edge> edges = prim.prim();
            ArrayList neigh_aux = new ArrayList();
            for (int i = 0; i < dmat.getElementCount(); ++i) {
                neigh_aux.add(new ArrayList());
            }
            for (Prim.Edge e : edges) {
                ((ArrayList)neigh_aux.get(e.node1)).add(new Pair(e.node2, e.len));
                ((ArrayList)neigh_aux.get(e.node2)).add(new Pair(e.node1, e.len));
            }
            Pair[][] neighborhood = new Pair[dmat.getElementCount()][];
            for (int i = 0; i < neigh_aux.size(); ++i) {
                neighborhood[i] = new Pair[((ArrayList)neigh_aux.get(i)).size()];
                for (int j = 0; j < ((ArrayList)neigh_aux.get(i)).size(); ++j) {
                    neighborhood[i][j] = (Pair)((ArrayList)neigh_aux.get(i)).get(j);
                }
            }
            Dijkstra d = new Dijkstra(neighborhood, dmat.getElementCount());
            for (int i = 0; i < dmat.getElementCount(); ++i) {
                float[] dist = d.execute(i);
                for (int j = 0; j < dist.length; ++j) {
                    new_dmat.setDistance(i, j, dist[j]);
                }
            }
            new_dmat.save(filename + "_new.dmat");
        }
        catch (IOException ex) {
            Logger.getLogger(Dijkstra.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

